/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.actions;


import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/**
 * 部品生成アクションクラスです
 * 
 * レイアウトエディタのコンテキストメニューから呼び出され
 * 現在選択している部品へ新たな部品を追加します。
  */
public class CreateComponentAction extends Action {
	
	/*
	 * 新たに生成する部品のファクトリクラス
	 */
	private CreationFactory factory = null;
	
	/*
	 * 追加元エディトパート
	 */
	private EditPart targetEditPart = null;
	
	/**
	 * コンストラクタです
	 * 
	 * @param message メッセージ
	 * @param image イメージ
	 * @param factory ファクトリクラス
	 * @param target 追加元エディトパート
	 */
	public CreateComponentAction(String message, Image image,
			CreationFactory factory, EditPart target) {
		super(message, ImageDescriptor.createFromImage(image));
		this.factory = factory;
		this.targetEditPart = target;
	}
	
	/**
	 * 生成リクエストを作成します
	 * 
	 * @return 生成リクエスト
	 */
	private Request createTargetRequest() {
		CreateRequest request = new CreateRequest();
		request.setFactory(factory);
		request.setLocation(getMouseLocation());
		request.setSize(new Dimension(-1, -1));
		return request;
	}

	/**
	 * アクション実行時のマウス位置を取得します
	 * 
	 * @return マウス座標
	 */
	private Point getMouseLocation() {
		IFigure figure = ((GraphicalEditPart) targetEditPart).getFigure();
		Rectangle rect = figure.getBounds().getCopy();
		Insets inset = figure.getInsets();
		if (inset != null) {
			rect.x += inset.left;
			rect.y += inset.top;
		}
		return new Point(rect.x, rect.y);
	}
	
	/**
	 * このアクションが実行可能かを判定します
	 * 
	 * @return 実行可能である場合、true を返却します
	 */
	public boolean isEnabled() {
		EditPartViewer viewer = targetEditPart.getViewer();
		Object model = factory.getNewObject();
		EditPart child = viewer.getEditPartFactory().createEditPart(null, model);
		
		if (targetEditPart instanceof LayoutElementEditPart) {
			if (!((LayoutElementEditPart) targetEditPart).canAddChild(model)) {
				return false;
			}
		}
		if (child instanceof LayoutElementEditPart) {
			if (!((LayoutElementEditPart) child).canAddParent(targetEditPart.getModel())) {
				return false;
			}
		}
		return true;
	}

	/**
	 * このアクションを実行します
	 */
	public void run() {
		Request request = createTargetRequest();
		Command command = targetEditPart.getCommand(request);
		if (command.canExecute()) {
			CommandStack cs = (CommandStack) targetEditPart.getAdapter(CommandStack.class);
			cs.execute(command);
			
			Object model = ((CreateRequest) request).getNewObject();
			EditPartViewer viewer = targetEditPart.getViewer();
			if (model != null && viewer != null) {
				Object editPart = viewer.getEditPartRegistry().get(model);
				if (editPart instanceof EditPart) {
					viewer.select((EditPart) editPart);
				}
			}			
		}
	}
	
	
}
