/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.actions;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.ui.editors.layout.editparts.LayoutEditPart;
import jp.sf.maskat.ui.editors.layout.outline.OutLineTreeEditPart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.ui.IWorkbenchPart;

/**
 * 削除アクションクラスです
 * 
 * レイアウトエディタのメニュー、コンテキストメニューから呼び出され
 * 現在選択しているLayoutElementクラスの削除を行います。
 * 
 * 親子関係を持つコンポーネントの重複するコマンドの作成を省くように
 * org.eclipse.gef.ui.actions.DeleteAction クラスを拡張しています。
  */
public class DeleteComponentAction extends DeleteAction {

	/**
	 * コンストラクタです
	 * 
	 * @param part アクションを行うWorkbenchPart
	 */
	public DeleteComponentAction(IWorkbenchPart part) {
		super(part);
	}

	/**
	 * 削除コマンドを作成します
	 * 
	 * @param objects 選択されているエディトパートのリスト
	 * @return 削除コマンド
	 */
	public Command createDeleteCommand(List objects) {
		List editParts = getDeleteSelectedObjects(objects);
		return super.createDeleteCommand(editParts);
	}
	
	/*
	 * 親子関係を持つコンポーネントが削除対象となっている場合
	 * 子コンポーネントの削除コマンドを省きます
	 * 
	 * @param object 選択されているエディトパートのリスト
	 * @return 親子関係で重複しているものを削除したリスト
	 */
	private List getDeleteSelectedObjects(List objects) {
		List list = new ArrayList();
		
		for (int i = 0; i < objects.size(); i++) {
			EditPart editPart = (EditPart) objects.get(i);
			EditPart e = editPart.getParent();

			if (e instanceof OutLineTreeEditPart) {
				list.add(editPart);
			} else {
				while (e != null && !(e instanceof LayoutEditPart)) {
					if (objects.contains(e)) {
						break;
					}
					e = e.getParent();
				}
				if (e instanceof LayoutEditPart) {
					list.add(editPart);
				}
			}
		}
		return list;
	}
}
