/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import org.eclipse.draw2d.IFigure;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.editors.layout.figures.TextFigure;

public class ComponentEditPart extends LayoutElementEditPart
	implements IdDirectEditable {

	protected IFigure createFigure() {
		return new TextFigure("");
	}

	public void refreshSelectedWidget(ComponentEditPart child) {
		if (getParent() instanceof ComponentEditPart) {
			((ComponentEditPart) getParent()).refreshSelectedWidget(this);
		}
		refreshVisuals();
	}
	
	public String getId() {
		return ((Component) getModel()).getName();
	}

	public void setId(String id) {
		((Component) getModel()).setName(id);
	}
		
	public boolean canCopy() {
		return true;
	}
}

