/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.outline;

import java.util.List;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;

public class OutLineTreeEditPartFactory implements EditPartFactory {

	private GraphicalViewer graphicalViewer = null;
	
	public OutLineTreeEditPartFactory(GraphicalViewer viewer) {
		graphicalViewer = viewer;
	}
	
	private EditPart findLayoutEditPart(EditPart root, Object model) {
		if (!(root instanceof RootEditPart)) {
			if (root.getModel() == model) {
				return root;
			}
		}		
		List partList = root.getChildren();
		for (int i = 0; i < partList.size(); i++) {
			EditPart part = findLayoutEditPart((EditPart) partList.get(i), model);
			if (part != null) {
				return part;
			}
		}
		return null;
	}
	
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart layoutPart = findLayoutEditPart(
				graphicalViewer.getRootEditPart(), model);
		OutLineTreeEditPart part = new OutLineTreeEditPart(layoutPart);
		part.setModel(model);
		return part;
	}
}
