/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutElement;


public class ComponentUtils {
	
	public static boolean isExistenceId(LayoutElement root, String id) {
		if (root instanceof Component) {
			if (id.equals(((Component) root).getName())) {
				return true;
			}
		}
		List elements = root.getChildren();
		for (int i = 0; i < elements.size(); i++) {
			Object element = elements.get(i);
			if (!(element instanceof LayoutElement)) {
				continue;
			}
			if (element instanceof Component) {
				if (id.equals(((Component) element).getName())) {
					return true;
				}
			}
			boolean exist = isExistenceId((LayoutElement) element, id);
			if (exist) {
				return true; 
			}
		}
		return false;
	}

	public static LayoutElement getLayoutElement(LayoutElement root, String id) {
		if (root instanceof Component) {
			if (id.equals(((Component) root).getName())) {
				return root;
			}
		}
		List elements = root.getChildren();
		for (int i = 0; i < elements.size(); i++) {
			Object element = elements.get(i);
			if (!(element instanceof LayoutElement)) {
				continue;
			}
			if (element instanceof Component) {
				if (id.equals(((Component) element).getName())) {
					return (LayoutElement) element;
				}
			}
			LayoutElement exist = getLayoutElement((LayoutElement) element, id);
			if (exist != null) {
				return exist; 
			}
		}
		return null;
	}
	
	public static void setUniqueName(Layout layout, Component component) {
		setUniqueName(layout, component, new ArrayList());
	}
	
	private static void setUniqueName(Layout layout, Component component, List invalidList) {
		String name = component.getName();
		String newName = ComponentUtils.getUniqueName(layout, name, invalidList);
		if (!newName.equals(name)) {
			try {
				component.setName(newName);
			} catch (IllegalArgumentException e) {
				
			}
		}
		List components = component.getTypedChildren(Component.class);
		for (int i = 0; i < components.size(); i++) {
			setUniqueName(layout, (Component) components.get(i), invalidList);
		}
	}
	
	public static String getUniqueName(LayoutElement root, String baseName) {
		return getUniqueName(root, baseName, null);
	}

	public static String getUniqueName(LayoutElement root, String baseName, List invalidList) {
		List componentList = getAllComponentList(root);
		if (baseName == null || "".equals(baseName)) { //$NON-NLS-1$
			baseName = "widget"; //$NON-NLS-1$
			
		} else {
			if (!componentList.contains(baseName) && !invalidList.contains(baseName)) {
				invalidList.add(baseName);
				return baseName;
			}	
			for (int i = baseName.length() - 1; i >= 0; i--) {
				String id = baseName.substring(i, i + 1);
				try {
					Integer.parseInt(id);
				} catch (NumberFormatException e) {
					baseName = baseName.substring(0, i + 1);
					break;
				}
			}
		}
		for (int i = 0; i < Integer.MAX_VALUE; i++) {
			StringBuffer sb = new StringBuffer(baseName);
			if (i != 0) {
				sb.append(i);
			}
			if (!componentList.contains(sb.toString())) {	
				if (!invalidList.contains(sb.toString())) {
					invalidList.add(sb.toString());
					return sb.toString();
				}
			}
		}
		return null;
	}
	
	private static List getAllComponentList(LayoutElement element) {
		//return element.getAllDescendants(element, Component.class);
		
		ArrayList list = new ArrayList();
		List elements = element.getChildren();
		for (int i = 0; i < elements.size(); i++) {
			Object object = elements.get(i);
			if (object instanceof LayoutElement) {
				if (object instanceof Component) {
					list.add(((Component) object).getName());
				}
				list.addAll(getAllComponentList((LayoutElement) object));
			}
		}
//		for (Iterator ite = element.getChildren(); ite != null && ite.hasNext();) {
//			Object obj = ite.next();
//			if (!(obj instanceof LayoutElement)) {
//				continue;
//			}
//			if (obj instanceof Component) {
//				list.add(((Component) obj).getName());
//			}
//			list.addAll(getAllComponentList((LayoutElement)obj));
//		}
		return list;
	}
}
