/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class IdTextCellEditor extends TextCellEditor
	implements DirectEditable {
	
	IdDirectEditable editable;
	EditPart targetEditPart;
	
	public IdTextCellEditor(Composite parent, int style, EditPart editPart) {
        super(parent, style);
        this.targetEditPart = editPart;
        this.editable = (IdDirectEditable) editPart.getAdapter(IdDirectEditable.class);
    }
	
	public String get() {
		return editable.getId();
	}
	
	public void set(String id) {
		LayoutElement element = (LayoutElement) targetEditPart.getModel();
		
		if (id == null || id.length() <= 0) {
		    MessageDialog.openWarning(Display.getCurrent().getActiveShell(),
		    		Messages.getString("outline.msg.warning.title"), //$NON-NLS-1$
		    		Messages.getString("outline.msg.error.noname")); //$NON-NLS-1$
		    
		} else if (ComponentUtils.isExistenceId(element.getLayout(), id)) {
		    MessageDialog.openWarning(Display.getCurrent().getActiveShell(),
		    		Messages.getString("outline.msg.warning.title"), //$NON-NLS-1$
		    		Messages.getString("outline.msg.error.existencename")); //$NON-NLS-1$
		} else {
			editable.setId(id);
		}
	}
}
