/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import jp.sf.maskat.ui.editors.layout.commands.SetPropertyCommand;
import jp.sf.maskat.ui.views.properties.tabbed.command.SetEventPropertyCommand;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.TreeViewer;

public class UndoableDataBindingTool extends DataBindingTool {

	private TreeViewer treeViewer;
	
	private Class classType;
	
	public UndoableDataBindingTool(TreeViewer treeViewer, Class classType, Object bean, String propertyName) {
		super(bean, propertyName);
		this.treeViewer = treeViewer;
		this.classType = classType;
	}
	
	protected Command getCommand() {
		Command command = super.getCommand();
		String newValue = command == null ? null : ((SetPropertyCommand)command).getNewValue();
		return new SetEventPropertyCommand(treeViewer, classType, bean, propertyName, newValue);
	}
}
