/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Header;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.HTTPHeaderTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;


public class HeaderTreeNode extends AbstractTreeNode {
	
	private boolean isGlobal = true;
	
	public HeaderTreeNode(Header header, boolean isGlobal) {
		super(header);
		this.isGlobal = isGlobal;
	}
	
	public boolean isGlobal() {
		if (maskatElement.getParent() == null) {
			return isGlobal;
		}
		return maskatElement.getParent() instanceof Event ? false : true;
	}

	public String getDisplayText() {

		Header header = (Header) maskatElement;
		String headerName = "";
		String headerValue = "";
		String headerType = null;
		
		if (header.getName() != null)
		{
			if  (!(header.getName().length() == 0))
			{
				headerName = header.getName();
			}
		}
		if (header.getValue() != null)
		{
			if (!(header.getValue().length() == 0))
			{
				headerValue = header.getValue();
			}
		}
		
		if (!isGlobal()) {
			headerType = Messages.getString("headerTreeNode.localLabel"); //$NON-NLS-1$
		} else {
			headerType = Messages.getString("headerTreeNode.globalLabel"); //$NON-NLS-1$
		}
		
		return headerName + " = " + headerValue + " " + headerType;
	}
	
	public boolean isCopiable() {
		return true;
	}
	
	public boolean canPasteTo(ITreeNode parent) {
		return (parent != null && parent instanceof HTTPHeaderTreeNode) ? true : false;
	}
}

/*
public String getDisplayText() {

	Header header = (Header) maskatElement;

	if (header.getName() == null || header.getName().equals(""))
	{
		if (maskatElement.getParent() instanceof Event) {
			return "<>" + " (local)";
		} else {
			return "<>" + " (global)";
		}
	}
	
	if (maskatElement.getParent() instanceof Event) {
		return header.getName() + " (local)";
	} else {
		return header.getName() + " (global)";
	}
}*/
