/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.LocalDataBindingTreeNode;


public class LocalDataBinding extends AbstractTreeNode {
	private static final String SINGLE_VALUE_LABEL =
		Messages.getString("localDataBinding.singleValueLabel"); //$NON-NLS-1$		
	
	public LocalDataBinding(Target target) {
		super(target);
	}

	public String getDisplayText() {
		Target target = (Target)maskatElement;
		Result result = (Result) target.getParent();
		Event event = (Event) result.getParent();
		
		String in = ((Target)maskatElement).getIn();
		in = (in == null || in.length() == 0) ? "" : in;
		String out = ((Target)maskatElement).getOut();
		out = (out == null || out.length() == 0) ? "" : out;
		
		if (target.getType().equals("local") || event.getType().equals("local")) {
			return in + " -> " + out + " " + SINGLE_VALUE_LABEL;
		}
		
		return in + " -> " + out;
	}
	
	public boolean isCopiable() {
		return true;
	}
	
	public boolean canPasteTo(ITreeNode parent) {
		return parent != null && parent instanceof LocalDataBindingTreeNode;
	}
}
