/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.event.Header;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.HeaderTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ChangeHeaderTypeCommand extends Command {

	private TreeViewer treeViewer;
	
	private Event event;
	
	private Header header;
	
	private MaskatElement parent;
	
	private String type;
	
	private Map headers;
	
	public ChangeHeaderTypeCommand(TreeViewer treeViewer,
			Event event, Header header, String type) {
		super();
		this.treeViewer = treeViewer;
		this.event = event;
		this.header = header;
		this.type = type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		try {
			if ("global".equals(type)) {
				executeLocalToGlobal();
			} else if ("local".equals(type)) {
				executeGlobalToLocal();
			} else if ("allLocal".equals(type)) {
				executeGlobalToAllLocal();
			}
			updateTreeViewer();
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		try {
			if ("global".equals(type)) {
				undoLocalToGlobal();
			} else if ("local".equals(type)) {
				undoGlobalToLocal();
			} else if ("allLocal".equals(type)) {
				undoGlobalToAllLocal();
			}
			updateTreeViewer();
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}
	
	private void updateTreeViewer() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
				header, HeaderTreeNode.class);
		if (treeNode != null) {
			treeViewer.update(treeNode, null);
			treeViewer.setSelection(new StructuredSelection(treeNode), true);
		}
	}
	
	private void executeLocalToGlobal() {
		this.parent = event.getParent();
		event.removeChild(header);
		if (this.parent instanceof EventDef) {
			((EventDef) this.parent).addChild(header);
		} else if (this.parent instanceof Component) {
			((EventDef) this.parent.getParent()).addChild(header);
		}
	}
	
	private void undoLocalToGlobal() {
		event.addChild(header);
		if (this.parent instanceof EventDef) {
			((EventDef) this.parent).removeChild(header);
		} else if (this.parent instanceof Component) {
			((EventDef) this.parent.getParent()).removeChild(header);
		}
	}
	
	private void executeGlobalToLocal() {
		this.parent = header.getParent();
		if (this.parent instanceof EventDef) {
			((EventDef) this.parent).removeChild(header);
		} else if (this.parent instanceof Component) {
			((Component) this.parent).removeChild(header);
		}
		this.event.addChild(header);
	}
	
	private void undoGlobalToLocal() {
		this.event.removeChild(header);
		if (this.parent instanceof EventDef) {
			((EventDef) this.parent).addChild(header);
		} else if (this.parent instanceof Component) {
			((Component) this.parent).addChild(header);
		}
	}
	
	private void executeGlobalToAllLocal() {
		this.parent = header.getParent();
		EventDef eventDef = null;
		String headerName = header.getName();
		String headerValue = header.getValue();
		this.headers = new HashMap();
		
		if (this.parent instanceof EventDef) {
			eventDef = (EventDef) this.parent;

			Event[] events = eventDef.getAllEvents();
			if (events.length > 0) {
				for (int i = 0; i < events.length; i++) {
					if (events[i] != this.event) {
						Header newHeader = new Header();
						newHeader.setName(headerName);
						newHeader.setValue(headerValue);
						events[i].addChild(newHeader);
						this.headers.put(events[i], newHeader);
					}
				}
			}
			Component[] components = eventDef.getAllComponents();
			if (components.length > 0) {
				for (int i = 0; i < components.length; i++) {
					Event[] evs = components[i].getAllEvents();
					if (evs.length > 0) {
						for (int j = 0; j < evs.length; j++) {
							if ("remote".equals(evs[j].getType()) &&
										evs[j] != event) {
								Header newHeader = new Header();
								newHeader.setName(headerName);
								newHeader.setValue(headerValue);
								evs[j].addChild(newHeader);
								this.headers.put(evs[j], newHeader);
							}
						}
					}
				}
			}
			eventDef.removeChild(header);
			this.event.addChild(header);
		}
	}
	
	private void undoGlobalToAllLocal() {
		if (this.parent instanceof EventDef) {
			EventDef eventDef = (EventDef) this.parent;
			eventDef.addChild(header);
			this.event.removeChild(header);

			for (Iterator ite = this.headers.keySet().iterator(); ite.hasNext();) {
				MaskatElement element = (MaskatElement) ite.next();
				element.removeChild(this.headers.get(element));
			}
		}
	}
}
