/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.ui.MaskatUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;

public class CompositePropertyCommand extends Command {
	
	private List commands = new ArrayList();	

	private boolean order;
	
	public CompositePropertyCommand() {	
		this(true);
	}

	public CompositePropertyCommand(boolean order) {	
		this.order = order;
	}
	
	public void addCommand(Command command) {
		this.commands.add(command);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#canUndo()
	 */
	public boolean canUndo() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		try {
			for (int i = 0; i < this.commands.size(); i++) {
				Command command = (Command) this.commands.get(i);
				if (command.canExecute()) {
					command.execute();
				}
			}

		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));			
		}		
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		try {
			if (this.order) {
				for (int i = this.commands.size() - 1; i >= 0; i--) {
					Command command = (Command) this.commands.get(i);
					if (command.canUndo()) {
						command.undo();
					}				
				}
			} else {
				for (int i = 0; i < this.commands.size(); i++) {
					Command command = (Command) this.commands.get(i);
					if (command.canUndo()) {
						command.undo();
					}
				}
			}

		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));			
		}	
	}
}
