/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.html.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.widget.html.figure.DivHtmlFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

public class DivHtmlEditPart extends ComponentEditPart
	implements LabelDirectEditable{
	
	protected IFigure createFigure() {
		return new DivHtmlFigure(getLabel());
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		int width = comp.getWidth() > 0 ? comp.getWidth() : 120;
		int height = comp.getHeight() > 0 ? comp.getHeight() : 80;
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), width,
				height);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("context".equals(evt.getPropertyName())) {
			((DivHtmlFigure) getFigure()).setText((String) evt.getNewValue());
		}
		super.propertyChange(evt);
	}

	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("context");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("context", text);
	}
}
