/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.widget.rialto.figure.ImageFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;


public class ImageEditPart extends ComponentEditPart {
	//implements  HorizontalResizable, VerticalResizable {
	
	protected IFigure createFigure() {
		return new ImageFigure();
	}

	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
	}

	protected void refreshVisuals() {
		DynaComponent comp = (DynaComponent) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), 16, 16);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
}
