/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.editors.layout.commands.SetPropertyCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.widget.rialto.editpolicy.SplitLineComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.SplitLineFeedBackEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.SplitLineLayoutPolicy;
import jp.sf.maskat.widget.rialto.figure.SplitLineFigure;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;



public class SplitLineEditPart extends ComponentEditPart {
	public static final Object SPLITLINE_MODEL = new Object();
	public SplitLineEditPart(Object model) {
		setModel(SPLITLINE_MODEL);
	}
	
	protected IFigure createFigure() {
		SplitLineFigure figure = new SplitLineFigure();
		figure.addMouseMotionListener(new MouseMotionListener.Stub() {
			public void mouseExited(MouseEvent me) {
				SplitterEditPart parent = (SplitterEditPart)
					SplitLineEditPart.this.getParent();
				
				parent.setDivSplitVisible(true);
				SplitLineFigure figure = (SplitLineFigure)
					SplitLineEditPart.this.getFigure();
				
				if (figure.isMouseMoveing()) {
					figure.setMouseMoveing(false);
					parent.getViewer().select(parent);
				}
			}
		});
		figure.addMouseListener(new MouseListener.Stub() {
			public void mousePressed(MouseEvent me) {
				SplitterEditPart parent = (SplitterEditPart)
					SplitLineEditPart.this.getParent();
				
				parent.setDivSplitVisible(false);
				SplitLineFigure figure = (SplitLineFigure)
					SplitLineEditPart.this.getFigure();
				
				figure.setMouseMoveing(true);
			}
		});
		return figure;
	}
	
	protected void refreshVisuals() {
		SplitterEditPart editPart = (SplitterEditPart) getParent();
		Component parent = (Component) editPart.getModel();
		Rectangle lineConstraint = null;
		/* HORIZONTAL */
		if ("h".equals(editPart.getOrientation())) {
			int x = (int) ((double) parent.getWidth() * editPart.getProp()) - 2;
			lineConstraint = new Rectangle(x, 0, 5, parent.getHeight() - 1);
			getFigure().setCursor(Cursors.SIZEWE);
		/* VERTICAL */
		} else {
			int y = (int) ((double) parent.getHeight() * editPart.getProp()) - 2;
			lineConstraint = new Rectangle(0, y, parent.getWidth() - 2, 5);
			getFigure().setCursor(Cursors.SIZENS);
		}
		editPart.getFigure().setConstraint(getFigure(), lineConstraint);
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE, new SplitLineFeedBackEditPolicy());
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new SplitLineComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new SplitLineLayoutPolicy());
	}

	public void installEditPolicy(Object key, EditPolicy editPolicy) {
		if (EditPolicy.PRIMARY_DRAG_ROLE.equals(key) &&
			!(editPolicy instanceof SplitLineFeedBackEditPolicy)) {
			return;
		}
		super.installEditPolicy(key, editPolicy);
	}

	public Command createConstrainCommand(Object model, Rectangle constraint) {
		if (model == SPLITLINE_MODEL) {
			Component parent = (Component) getParent().getModel();
			String orientation = ((SplitterEditPart) getParent()).getOrientation();
			double value = 0.0;
			if ("h".equals(orientation)) {
				value = (parent.getWidth() == 0) ? 0 :
						(double) constraint.x / (double) parent.getWidth();
			} else {
				value = (parent.getHeight() == 0) ? 0 :
					(double) constraint.y / (double) parent.getHeight();
			}
			double prop = (double) (Math.round(value * 1000.0) / 1000.0);
			return new SetPropertyCommand(parent, "prop", new Double(prop));
		}
		return null;
	}
	
	public boolean canAddParent(Object parent) {
		return false;
	}
	
	public boolean canCopy() {
		return false;
	}

	public boolean canDelete() {
		return false;
	}
}
