/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;

public class ImageFigure extends Label {
	
	public ImageFigure() {
		setForegroundColor(ColorConstants.black);
		setBorder(new LineBorder());
		setLayoutManager(new XYLayout());
	}

	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);
		graphics.drawLine(0, 0, bounds.width, bounds.height);
		graphics.drawLine(bounds.width, 0, 0, bounds.height);
		graphics.translate(-bounds.x, -bounds.y);
	}
}
