﻿using System;
using System.Windows.Forms;

namespace masterframe
{
    static class Program
    {
        /// <summary>
        /// It is the main entry point of application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            try
            {
                // Version information
                System.Diagnostics.FileVersionInfo asmVer
                    = System.Diagnostics.FileVersionInfo.GetVersionInfo(
                            System.Reflection.Assembly.GetExecutingAssembly().Location);

                ////check the double boot from process name
                ////string pname = System.Diagnostics.Process.GetCurrentProcess().ProcessName;
                //if (1 < System.Diagnostics.Process.GetProcessesByName(
                //    asmVer.FileDescription).Length)
                //{
                //    //MessageBox.Show("Multiple start-up is not possible.");
                //    NLog.LogManager.GetCurrentClassLogger().Info("多重起動はできません ");
                //    return;
                //}

                //// 起動前に多重起動チェック(MUTEX生成し所有権取得できるかどうか確認)
                //bool createdNew;
                //System.Threading.Mutex mutex = new System.Threading.Mutex(
                //    true, asmVer.FileDescription, out createdNew);
                //if (createdNew == false)
                //{
                //    //MessageBox.Show("多重起動はできません。");
                //    NLog.LogManager.GetCurrentClassLogger().Info("多重起動はできません ");
                //    return;
                //}

                masterframe.control.MasterPool.Startup();

                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new masterframe.view.EntityForm());

                //// 多重起動防止用MUTEX解放
                //mutex.ReleaseMutex();
            }
            catch (Exception e)
            {
                NLog.LogManager.GetCurrentClassLogger().Error("Error Occurred at start-up" + e.Message);
                if (null != e.InnerException)
                    NLog.LogManager.GetCurrentClassLogger().Error(e.InnerException.Message);
            }
        }
    }
}
