﻿using System.Collections.Generic;
using System.Data;
using System.Windows.Forms;

namespace masterframe
{
    /// <summary>
    /// SqlServerEntityインスタンス
    /// 機能拡張用
    /// </summary>
    public class MyEntity : masterframe.model.entity.Entity
    {
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();

        /// <summary>
        /// データソースでインスタンス化
        /// </summary>
        /// <param name="p"></param>
        public MyEntity(string p, string select, string delete = "")
            : base(p, select, delete)
        {
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="tbl"></param>
        /// <returns></returns>
        public new string Validate(DataTable tbl = null)
        {
            var ret = base.Validate(tbl);
            if (0 < ret.Length) return ret;

            try
            {
                if (null == tbl) tbl = this.entities;

                int i = 0;
                foreach (DataRow row in tbl.Rows)
                {
                    if (row.RowState == System.Data.DataRowState.Deleted) continue; // 削除は数えない

                    i++;

                    if (row.RowState == System.Data.DataRowState.Unchanged) continue;


                    //if (tbl.Columns.Contains("DISPVAL"))
                    //{
                    //    var val = row["DISPVAL"].ToString();
                    //    if (0 < val.Length)
                    //    {
                    //        var sval = row["DISPVAL"].ToString();
                    //        var vals = sval.Split(':');
                    //        if (2 < vals.Length) return sval + " n:n と入力してください(" + i.ToString() + "行目) ";
                    //        if (1 == vals.Length) return sval + " n:n と入力してください(" + i.ToString() + "行目) ";

                    //        int i1 = 0;
                    //        int i2 = 0;

                    //        if (!int.TryParse(vals[0], out i1)) return sval + " 数値:n で入力してください(" + i.ToString() + "行目) ";
                    //        if (!int.TryParse(vals[1], out i2)) return sval + " n:数値 で入力してください(" + i.ToString() + "行目) ";
                    //    }
                    //}

                }
                return "";
            }
            catch (System.Exception e)
            {
                logger.Error(e, e.Message);
                return "データの取得に失敗しました [" + e.Message + "] ";
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public new string InsertOrUpdate()
        {
            try
            {
                var tbl = this.entities;
                foreach (DataRow row in tbl.Rows)
                {
                    if (row.RowState == System.Data.DataRowState.Deleted) continue; // 削除は数えない

                    //if (tbl.Columns.Contains("DISPVAL"))
                    //{
                    //    var sval = row["DISPVAL"].ToString();
                    //    var vals = sval.Split(':');
                    //    if (2 < vals.Length) continue;
                    //    if (1 == vals.Length) continue;

                    //    int i1 = 0;
                    //    int i2 = 0;

                    //    if (!int.TryParse(vals[0], out i1)) continue;
                    //    if (!int.TryParse(vals[1], out i2)) continue;

                    //    var val = i1 * 60 + i2;
                    //    if (1439 < val) val = 1439; // 24 * 60 - 1;
                    //    row["VAL"] = val;
                    //}
                }
                return base.InsertOrUpdate();
            }
            catch (System.Exception ex)
            {
                logger.Error(ex, ex.Message);
                return "データの変更に失敗しました [" + ex.Message + "]";
            }
        }
    }
}
