/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.net.MalformedURLException;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.project.Project;

public class RepositoryInfoBuilder {
    public static RepositoryInfo getRepositoryInfo(Project project, String repository) throws MalformedURLException {
        RepositoryInfo repoInfo = new RepositoryInfo();
        repoInfo.setRepositoryAlias(repository);
        String url = (String)project.getContext().getVariable("maven.repo." + repository);
        String username = (String)project.getContext().getVariable("maven.repo." + repository + ".username");
        String password = (String)project.getContext().getVariable("maven.repo." + repository + ".password");
        String passphrase = (String)project.getContext().getVariable("maven.repo." + repository + ".passphrase");
        String privateKey = (String)project.getContext().getVariable("maven.repo." + repository + ".privatekey");
        String dir = (String)project.getContext().getVariable("maven.repo." + repository + ".directory");
        String port = (String)project.getContext().getVariable("maven.repo." + repository + ".port");
        String remoteGroup = (String)project.getContext().getVariable("maven.repo." + repository + ".group");
        String proxyHost = project.getContext().getProxyHost();
        String proxyUser = project.getContext().getProxyUserName();
        String proxyPassword = project.getContext().getProxyPassword();
        String proxyPort = project.getContext().getProxyPort();
        repoInfo.setUserName(username);
        repoInfo.setPassword(password);
        repoInfo.setPassphrase(passphrase);
        repoInfo.setPrivateKey(privateKey);
        repoInfo.setGroup(remoteGroup);
        repoInfo.setUrl(url);
        repoInfo.setProxyHost(proxyHost);
        repoInfo.setProxyUserName(proxyUser);
        repoInfo.setProxyPassword(proxyPassword);
        if (port != null) {
            try {
                repoInfo.setPort(Integer.parseInt(port));
            }
            catch (Exception e) {
                throw new MalformedURLException("maven.repo." + repository + ".port should be an integer");
            }
        }
        if (proxyPort != null) {
            try {
                repoInfo.setProxyPort(Integer.parseInt(proxyPort.trim()));
            }
            catch (Exception e) {
                throw new MalformedURLException("maven.repo." + repository + ".proxy.port should be an integer");
            }
        }
        repoInfo.setBasedir(dir);
        return repoInfo;
    }
}

