/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.AbstractDeployer;
import org.apache.maven.deploy.deployers.Deployer;
import org.apache.maven.deploy.deployers.ExternalDeployer;
import org.apache.maven.deploy.deployers.FileDeployer;
import org.apache.maven.deploy.deployers.FtpDeployer;
import org.apache.maven.deploy.deployers.HttpDeployer;
import org.apache.maven.deploy.deployers.SFtpDeployer;
import org.apache.maven.deploy.deployers.ScpDeployer;
import org.apache.maven.deploy.exceptions.AuthenticationException;
import org.apache.maven.deploy.exceptions.TransferFailedException;
import org.apache.maven.deploy.exceptions.UnsupportedProtocolException;

public class DeployTool {
    public static final String VERSION = "1.0-dev";

    public Deployer getDeployer(RepositoryInfo repoInfo) throws IllegalArgumentException, UnsupportedProtocolException {
        String url = repoInfo.getUrl();
        AbstractDeployer deployer = null;
        if (url == null || url.length() == 1) {
            throw new UnsupportedProtocolException("No URL was provided repository: " + repoInfo.getRepositoryAlias());
        }
        if (url.startsWith("http://")) {
            deployer = new HttpDeployer();
        }
        if (url.startsWith("file://")) {
            deployer = new FileDeployer();
        }
        if (url.startsWith("ftp://")) {
            deployer = new FtpDeployer();
        }
        if (url.startsWith("sftp://")) {
            deployer = new SFtpDeployer();
        }
        if (url.startsWith("scp://")) {
            deployer = new ScpDeployer();
        }
        if (url.startsWith("external://")) {
            deployer = new ExternalDeployer();
        }
        if (deployer == null) {
            throw new UnsupportedProtocolException(url);
        }
        return deployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(RepositoryInfo repoInfo, List srcFiles, List destFiles) throws TransferFailedException, UnsupportedProtocolException, AuthenticationException {
        if (srcFiles.size() != destFiles.size()) {
            String msg = "Lengths of the lists should be the same";
            throw new IllegalArgumentException(msg);
        }
        Deployer deployer = this.getDeployer(repoInfo);
        try {
            deployer.init(repoInfo);
            Iterator srcIterator = srcFiles.iterator();
            Iterator destIterator = destFiles.iterator();
            while (srcIterator.hasNext()) {
                String srcFile = (String)srcIterator.next();
                String destFile = (String)destIterator.next();
                DeployRequest request = new DeployRequest(srcFile, destFile);
                System.out.println("Deploying: " + srcFile + "-->" + destFile);
                deployer.deploy(request);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                deployer.release();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            deployer.release();
        }
        catch (Exception e) {}
    }
}

