/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.GenericSshDeployer;
import org.apache.maven.deploy.exceptions.AuthenticationException;
import org.apache.maven.deploy.exceptions.TransferFailedException;
import org.apache.maven.deploy.util.Packager;

public class ScpDeployer
extends GenericSshDeployer {
    public static final String PROTOCOL = "scp://";
    public static final String EXEC_CHANNEL = "exec";
    public static final String COMPRESS = "maven.deployer.scp.compress";
    public boolean deployNotCompressed = true;
    private List srcFiles = new LinkedList();
    private List destFiles = new LinkedList();

    public void flush() throws TransferFailedException {
        if (!this.deployNotCompressed) {
            this.doDeployCompressed();
        }
        super.flush();
    }

    public boolean isDeployNotCompressed() {
        return this.deployNotCompressed;
    }

    public void setDeployNotCompressed(boolean deployNotCompressed) {
        this.deployNotCompressed = deployNotCompressed;
    }

    public void init(RepositoryInfo repoInfo) throws AuthenticationException {
        this.setDeployNotCompressed(Boolean.getBoolean(COMPRESS));
        super.init(repoInfo);
    }

    public void deploy(DeployRequest request) throws TransferFailedException {
        if (this.deployNotCompressed) {
            this.doDeployNotCompressed(request);
        } else {
            this.srcFiles.add(request.getSrcFile());
            this.destFiles.add(request.getDestFile());
        }
    }

    public void doDeployNotCompressed(DeployRequest request) throws TransferFailedException {
        Session session = this.getSession();
        String mkdirCmd = "mkdir -p " + this.getRepositoryInfo().getBasedir() + "/" + request.dirname() + "\n";
        this.executeSimpleCommand(session, mkdirCmd);
        this.doCopy(session, request);
        if (this.getRepositoryInfo().getGroup() != null) {
            String chgrpCmd = "chgrp " + this.getRepositoryInfo().getGroup() + " " + this.getRepositoryInfo().getBasedir() + "/" + request.getDestFile() + "\n";
            this.executeSimpleCommand(session, chgrpCmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeployCompressed() throws TransferFailedException {
        Session session = this.getSession();
        File zip = null;
        try {
            zip = File.createTempFile("maven-deployer-", ".zip");
            Packager.createZip(this.srcFiles, this.destFiles, zip);
        }
        catch (IOException e) {
            if (zip != null && zip.exists()) {
                try {
                    zip.delete();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            throw new TransferFailedException("Cannot create ZIP file");
        }
        try {
            DeployRequest request = new DeployRequest(zip.getAbsolutePath(), zip.getName());
            this.doCopy(session, request);
            String unzipCmd = "unzip -d -u " + this.getRepositoryInfo().getBasedir() + " " + this.getRepositoryInfo().getBasedir() + "/" + request.getDestFile() + "\n";
            this.executeSimpleCommand(session, unzipCmd);
            String rmCmd = "rm -f " + this.getRepositoryInfo().getBasedir() + "/" + request.getDestFile() + "\n";
            this.executeSimpleCommand(session, rmCmd);
            if (this.getRepositoryInfo().getGroup() != null) {
                String chgrpCmd = "chgrp -r" + this.getRepositoryInfo().getGroup() + " " + this.getRepositoryInfo().getBasedir() + "\n";
                this.executeSimpleCommand(session, chgrpCmd);
            }
        }
        finally {
            if (zip != null && zip.exists()) {
                try {
                    zip.delete();
                }
                catch (Exception ee) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeSimpleCommand(Session session, String command) throws TransferFailedException {
        System.out.println("Executing command: " + command);
        ChannelExec channel = null;
        try {
            try {
                channel = (ChannelExec)session.openChannel(EXEC_CHANNEL);
                channel.setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
            }
            catch (Exception e) {
                throw new TransferFailedException("Cannot execute remote command: " + command);
            }
            Object var7_7 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        channel.disconnect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCopy(Session session, DeployRequest request) throws TransferFailedException {
        ChannelExec channel = null;
        try {
            try {
                int len;
                String srcFile = request.getSrcFile();
                String destFile = this.getRepositoryInfo().getBasedir() + "/" + request.getDestFile();
                String command = "scp -t " + destFile;
                System.out.println("Executing command: " + command);
                channel = (ChannelExec)session.openChannel(EXEC_CHANNEL);
                channel.setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                byte[] tmp = new byte[1];
                do {
                    in.read(tmp, 0, 1);
                } while (tmp[0] != 0);
                int filesize = (int)new File(srcFile).length();
                command = "C0644 " + filesize + " ";
                command = srcFile.lastIndexOf(47) > 0 ? command + srcFile.substring(srcFile.lastIndexOf(47) + 1) : command + srcFile;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                do {
                    in.read(tmp, 0, 1);
                } while (tmp[0] != 0);
                FileInputStream fis = new FileInputStream(srcFile);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                    out.flush();
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                do {
                    in.read(tmp, 0, 1);
                } while (tmp[0] != 0);
            }
            catch (Exception e) {
                String msg = "Error occured while deploying to remote host:" + this.getRepositoryInfo().getHost();
                throw new TransferFailedException(msg, e);
            }
            Object var15_16 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        channel.disconnect();
    }
}

