/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.html2xdoc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class Html2XdocBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$html2xdoc$Html2XdocBean == null ? (class$org$apache$maven$html2xdoc$Html2XdocBean = Html2XdocBean.class$("org.apache.maven.html2xdoc.Html2XdocBean")) : class$org$apache$maven$html2xdoc$Html2XdocBean));
    private DocumentFactory factory = new DocumentFactory();
    private Element currentNode = null;
    private Element currentSectionNode = null;
    private int currentSectionHeadingLevel = Integer.MIN_VALUE;
    private Element currentParaNode = null;
    static /* synthetic */ Class class$org$apache$maven$html2xdoc$Html2XdocBean;

    public Document convert(Document html) {
        Document doc = this.factory.createDocument();
        Element root = doc.addElement("document");
        Element properties = root.addElement("properties");
        Element title = properties.addElement("title");
        title.setText(html.valueOf("/html/head/title"));
        Element body = root.addElement("body");
        Element htmlContent = (Element)html.selectSingleNode("/html/body");
        if (htmlContent == null) {
            log.info((Object)("No body element found for HTML document: " + html.asXML()));
        } else {
            this.addSections(body, htmlContent);
        }
        return doc;
    }

    protected void addSections(Element output, Element body) {
        List content = this.getBodyContent(body.content());
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (this.isHeading(node)) {
                this.makeSection(output, node);
                continue;
            }
            this.guaranteeHasSection(output);
            this.processNode(node);
        }
    }

    private void processNode(Node node) {
        if (this.isCharacterData(node)) {
            this.addTextNode(node);
        } else if (this.isTextFormatting(node)) {
            this.addFormattingNode(node);
        } else {
            this.addNode(node);
        }
    }

    protected boolean isTextFormatting(Node node) {
        return node.getName() != null && node.getName().equals("a");
    }

    protected boolean isCharacterData(Node node) {
        return node instanceof CharacterData && !(node instanceof Comment);
    }

    protected boolean isHeading(Node node) {
        String name = node.getName();
        return name != null && name.startsWith("h");
    }

    protected int determineHeadingLevel(Node node) {
        try {
            String name = node.getName().substring(1);
            return Integer.parseInt(name);
        }
        catch (NumberFormatException nfe) {
            return 1;
        }
    }

    protected void makeSection(Element output, Node node) {
        int level = this.determineHeadingLevel(node);
        if (this.needsNewSection(node)) {
            this.currentNode = output.addElement("section");
            this.currentSectionHeadingLevel = level;
            this.currentSectionNode = this.currentNode;
        } else {
            this.currentNode = this.currentSectionNode.addElement("subsection");
        }
        this.currentNode.addAttribute("name", this.getSectionText(node));
        this.currentParaNode = null;
    }

    protected String getSectionText(Node node) {
        Element element;
        List childElements;
        String text = node.getText().trim();
        if (text.length() <= 0 && node instanceof Element && !(childElements = (element = (Element)node).elements()).isEmpty()) {
            Node child = (Node)childElements.get(0);
            return child.getText();
        }
        return text;
    }

    protected boolean needsNewSection(Node node) {
        int level = this.determineHeadingLevel(node);
        return level <= this.currentSectionHeadingLevel || this.currentSectionNode == null;
    }

    private void guaranteeHasParaNode() {
        if (this.currentParaNode == null) {
            this.currentParaNode = this.currentNode.addElement("p");
        }
    }

    private void guaranteeHasSection(Element output) {
        if (this.currentNode == null) {
            this.currentNode = output.addElement("section");
        }
    }

    private void addNode(Node node) {
        if (this.currentParaNode != null && !this.shouldBreakPara(node)) {
            this.currentParaNode.add(this.cloneNode(node));
        } else {
            this.currentNode.add(this.cloneNode(node));
            this.currentParaNode = null;
        }
    }

    protected boolean shouldBreakPara(Node node) {
        String name = node.getName();
        return name.equals("p") || name.equals("br");
    }

    private void addTextNode(Node node) {
        this.guaranteeHasParaNode();
        this.currentParaNode.addText(node.getText());
    }

    private void addFormattingNode(Node node) {
        this.guaranteeHasParaNode();
        this.currentParaNode.add(this.cloneNode(node));
    }

    protected List getBodyContent(List content) {
        Node node;
        Element lastPre = null;
        LinkedList<Object> list = new LinkedList<Object>();
        boolean lastWasElement = true;
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            node = (Node)iter.next();
            if (this.isPre(node)) {
                if (lastPre == null) {
                    lastPre = this.factory.createElement("source");
                    list.add(lastPre);
                }
                lastPre.addText(node.getText());
                continue;
            }
            if (this.isWhitespace(node) && lastWasElement) {
                if (lastPre == null) continue;
                lastPre.addText(node.getText());
                continue;
            }
            lastWasElement = node instanceof Element;
            if (lastWasElement) {
                lastPre = null;
            }
            list.add(node);
        }
        while (this.isWhitespace(node = (Node)list.getFirst())) {
            list.removeFirst();
        }
        while (this.isWhitespace(node = (Node)list.getLast())) {
            list.removeLast();
        }
        return list;
    }

    protected boolean isPre(Node node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            return element.getName().equals("pre");
        }
        return false;
    }

    protected boolean isWhitespace(Node node) {
        if (node instanceof CharacterData) {
            String text = node.getText();
            return text.trim().length() <= 0;
        }
        return false;
    }

    protected Node cloneNode(Node node) {
        Node answer = (Node)node.clone();
        if (answer instanceof Element) {
            Element element = (Element)answer;
            element.normalize();
        }
        return answer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

