/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jellydoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLDoclet
extends Doclet {
    private String xmlns = "jvx";
    private String encodingFormat = "UTF-8";
    private String localName = "javadoc";
    private ContentHandler cm = null;
    private String targetFileName = null;
    private Attributes emptyAtts = new AttributesImpl();

    public XMLDoclet(RootDoc root) throws Exception {
        this.readOptions(root);
        File targetFile = new File(this.targetFileName);
        targetFile.getParentFile().mkdirs();
        FileOutputStream writer = new FileOutputStream(this.targetFileName);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(this.encodingFormat);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)writer, format);
        try {
            this.cm = xmlWriter;
            this.cm.startDocument();
            this.javadocXML(root);
            this.cm.endDocument();
            xmlWriter.close();
        }
        catch (IOException e) {
            xmlWriter.close();
            throw e;
        }
    }

    private void javadocXML(RootDoc root) throws SAXException {
        this.cm.startElement(this.xmlns, this.localName, "javadoc", this.emptyAtts);
        PackageDoc[] packageArray = root.specifiedPackages();
        int i = 0;
        while (i < packageArray.length) {
            this.packageXML(packageArray[i]);
            ++i;
        }
        ClassDoc[] classArray = root.specifiedClasses();
        Vector<ClassDoc> interfaceVector = new Vector<ClassDoc>();
        int i2 = 0;
        while (i2 < classArray.length) {
            if (classArray[i2].isInterface()) {
                interfaceVector.addElement(classArray[i2]);
            } else {
                this.classXML(classArray[i2]);
            }
            ++i2;
        }
        Enumeration interfaceEnum = interfaceVector.elements();
        if (interfaceEnum.hasMoreElements()) {
            ClassDoc interfaceDoc = (ClassDoc)interfaceEnum.nextElement();
            this.interfaceXML(interfaceDoc);
        }
        this.cm.endElement(this.xmlns, this.localName, "javadoc");
    }

    private void packageXML(PackageDoc packageDoc) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", packageDoc.name());
        this.cm.startElement(this.xmlns, this.localName, "package", atts);
        this.docXML((Doc)packageDoc);
        ClassDoc[] classArray = packageDoc.ordinaryClasses();
        int i = 0;
        while (i < classArray.length) {
            this.classXML(classArray[i]);
            ++i;
        }
        classArray = packageDoc.exceptions();
        int i2 = 0;
        while (i2 < classArray.length) {
            this.classXML(classArray[i2]);
            ++i2;
        }
        classArray = packageDoc.errors();
        int i3 = 0;
        while (i3 < classArray.length) {
            this.classXML(classArray[i3]);
            ++i3;
        }
        ClassDoc[] interfaceArray = packageDoc.interfaces();
        int i4 = 0;
        while (i4 < interfaceArray.length) {
            this.interfaceXML(interfaceArray[i4]);
            ++i4;
        }
        this.cm.endElement(this.xmlns, this.localName, "package");
    }

    private void classXML(ClassDoc classDoc) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", classDoc.name());
        String extensibility = "default";
        if (classDoc.isAbstract()) {
            extensibility = "abstract";
        } else if (classDoc.isFinal()) {
            extensibility = "final";
        }
        atts.addAttribute(this.xmlns, this.localName, "extensibility", "String", extensibility);
        String access = "package";
        if (classDoc.isPublic()) {
            access = "public";
        }
        atts.addAttribute(this.xmlns, this.localName, "access", "String", access);
        this.cm.startElement(this.xmlns, this.localName, "class", atts);
        this.docXML((Doc)classDoc);
        this.extendsXML(classDoc);
        this.implementsXML(classDoc);
        FieldDoc[] fieldArray = classDoc.fields();
        int i = 0;
        while (i < fieldArray.length) {
            this.fieldXML(fieldArray[i]);
            ++i;
        }
        ConstructorDoc[] constructorArray = classDoc.constructors();
        int i2 = 0;
        while (i2 < constructorArray.length) {
            this.constructorXML(constructorArray[i2]);
            ++i2;
        }
        MethodDoc[] methodArray = classDoc.methods();
        int i3 = 0;
        while (i3 < methodArray.length) {
            this.methodXML(methodArray[i3]);
            ++i3;
        }
        ClassDoc[] innerClassArray = classDoc.innerClasses();
        int i4 = 0;
        while (i4 < innerClassArray.length) {
            this.innerClassXML(innerClassArray[i4]);
            ++i4;
        }
        this.cm.endElement(this.xmlns, this.localName, "class");
    }

    private void extendsXML(ClassDoc classDoc) throws SAXException {
        if (classDoc.superclass() != null) {
            this.cm.startElement(this.xmlns, this.localName, "extends_class", this.emptyAtts);
            this.createRefXML("classref", classDoc.superclass().qualifiedName());
            this.cm.endElement(this.xmlns, this.localName, "extends_class");
        }
    }

    private void innerClassXML(ClassDoc classDoc) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", classDoc.name());
        String access = "package";
        if (classDoc.isPublic()) {
            access = "public";
        }
        atts.addAttribute(this.xmlns, this.localName, "access", "String", access);
        atts.addAttribute(this.xmlns, this.localName, "abstract", "String", "" + classDoc.isAbstract());
        String anonymous = "false";
        if (classDoc.name().equals("")) {
            anonymous = "true";
        }
        atts.addAttribute(this.xmlns, this.localName, "anonymous", "String", "" + anonymous);
        atts.addAttribute(this.xmlns, this.localName, "final", "String", "" + classDoc.isFinal());
        atts.addAttribute(this.xmlns, this.localName, "static", "String", "" + classDoc.isStatic());
        this.cm.startElement(this.xmlns, this.localName, "innerclass", atts);
        this.docXML((Doc)classDoc);
        this.extendsXML(classDoc);
        this.implementsXML(classDoc);
        FieldDoc[] fieldArray = classDoc.fields();
        int i = 0;
        while (i < fieldArray.length) {
            this.fieldXML(fieldArray[i]);
            ++i;
        }
        ConstructorDoc[] constructorArray = classDoc.constructors();
        int i2 = 0;
        while (i2 < constructorArray.length) {
            this.constructorXML(constructorArray[i2]);
            ++i2;
        }
        MethodDoc[] methodArray = classDoc.methods();
        int i3 = 0;
        while (i3 < methodArray.length) {
            this.methodXML(methodArray[i3]);
            ++i3;
        }
        this.cm.endElement(this.xmlns, this.localName, "innerclass");
    }

    private void interfaceXML(ClassDoc interfaceDoc) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", interfaceDoc.name());
        String access = "package";
        if (interfaceDoc.isPublic()) {
            access = "public";
        }
        atts.addAttribute(this.xmlns, this.localName, "access", "String", access);
        this.cm.startElement(this.xmlns, this.localName, "interface", atts);
        this.docXML((Doc)interfaceDoc);
        this.extends_interfaceXML(interfaceDoc);
        FieldDoc[] fieldArray = interfaceDoc.fields();
        int i = 0;
        while (i < fieldArray.length) {
            this.fieldXML(fieldArray[i]);
            ++i;
        }
        MethodDoc[] methodArray = interfaceDoc.methods();
        int i2 = 0;
        while (i2 < methodArray.length) {
            this.methodXML(methodArray[i2]);
            ++i2;
        }
        this.cm.endElement(this.xmlns, this.localName, "interface");
    }

    private void extends_interfaceXML(ClassDoc interfaceDoc) throws SAXException {
        ClassDoc[] interfaceArray = interfaceDoc.interfaces();
        if (interfaceArray.length > 0) {
            this.cm.startElement(this.xmlns, this.localName, "extends_interface", this.emptyAtts);
            int i = 0;
            while (i < interfaceArray.length) {
                this.createRefXML("interfaceref", interfaceArray[i].qualifiedName());
                ++i;
            }
            this.cm.endElement(this.xmlns, this.localName, "extends_interface");
        }
    }

    private void implementsXML(ClassDoc classDoc) throws SAXException {
        ClassDoc[] interfaceArray = classDoc.interfaces();
        if (interfaceArray.length > 0) {
            this.cm.startElement(this.xmlns, this.localName, "implements", this.emptyAtts);
            int i = 0;
            while (i < interfaceArray.length) {
                this.createRefXML("interfaceref", interfaceArray[i].qualifiedName());
                ++i;
            }
            this.cm.endElement(this.xmlns, this.localName, "implements");
        }
        if (classDoc.superclass() != null) {
            this.implementsXML(classDoc.superclass());
        }
    }

    private void throwsXML(ExecutableMemberDoc member) throws SAXException {
        ThrowsTag[] tagArray = member.throwsTags();
        if (tagArray.length > 0) {
            this.cm.startElement(this.xmlns, this.localName, "throws", this.emptyAtts);
            int i = 0;
            while (i < tagArray.length) {
                ClassDoc exceptionClass = tagArray[i].exception();
                String name = null;
                name = exceptionClass == null ? tagArray[i].exceptionName() : tagArray[i].exception().qualifiedName();
                this.createRefXML("classref", name);
                ++i;
            }
            this.cm.endElement(this.xmlns, this.localName, "throws");
        }
    }

    private void createRefXML(String elementName, String nameValue) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", nameValue);
        this.cm.startElement(this.xmlns, this.localName, elementName, atts);
        this.cm.endElement(this.xmlns, this.localName, elementName);
    }

    private void createTypeRef(Type type) throws SAXException {
        String qualifiedName = type.qualifiedTypeName();
        ClassDoc fieldType = type.asClassDoc();
        if (fieldType == null) {
            AttributesImpl subElmAtts = new AttributesImpl();
            subElmAtts.addAttribute(this.xmlns, this.localName, "type", "String", qualifiedName);
            this.cm.startElement(this.xmlns, this.localName, "primitive", subElmAtts);
            this.cm.endElement(this.xmlns, this.localName, "primitive");
        } else if (fieldType.isInterface()) {
            this.createRefXML("interfaceref", qualifiedName);
        } else {
            this.createRefXML("classref", qualifiedName);
        }
    }

    private void fieldXML(FieldDoc field) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", field.name());
        String access = "package";
        if (field.isPrivate()) {
            access = "private";
        } else if (field.isProtected()) {
            access = "protected";
        } else if (field.isPublic()) {
            access = "public";
        }
        atts.addAttribute(this.xmlns, this.localName, "access", "String", access);
        atts.addAttribute(this.xmlns, this.localName, "dimension", "String", field.type().dimension());
        atts.addAttribute(this.xmlns, this.localName, "synthetic", "String", "" + field.isSynthetic());
        atts.addAttribute(this.xmlns, this.localName, "static", "String", "" + field.isStatic());
        atts.addAttribute(this.xmlns, this.localName, "final", "String", "" + field.isFinal());
        atts.addAttribute(this.xmlns, this.localName, "transient", "String", "" + field.isTransient());
        atts.addAttribute(this.xmlns, this.localName, "volatile", "String", "" + field.isVolatile());
        this.cm.startElement(this.xmlns, this.localName, "field", atts);
        this.docXML((Doc)field);
        this.createTypeRef(field.type());
        this.cm.endElement(this.xmlns, this.localName, "field");
    }

    private void constructorXML(ConstructorDoc constrDoc) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", constrDoc.qualifiedName());
        String access = "package";
        if (constrDoc.isPrivate()) {
            access = "private";
        } else if (constrDoc.isProtected()) {
            access = "protected";
        } else if (constrDoc.isPublic()) {
            access = "public";
        }
        atts.addAttribute(this.xmlns, this.localName, "access", "String", access);
        atts.addAttribute(this.xmlns, this.localName, "synthetic", "String", "" + constrDoc.isSynthetic());
        this.cm.startElement(this.xmlns, this.localName, "constructor", atts);
        this.docXML((Doc)constrDoc);
        Parameter[] parameterArray = constrDoc.parameters();
        int i = 0;
        while (i < parameterArray.length) {
            this.parameterXML(parameterArray[i]);
            ++i;
        }
        this.throwsXML((ExecutableMemberDoc)constrDoc);
        this.cm.endElement(this.xmlns, this.localName, "constructor");
    }

    private void methodXML(MethodDoc methodDoc) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", methodDoc.name());
        String access = "package";
        if (methodDoc.isPrivate()) {
            access = "private";
        } else if (methodDoc.isProtected()) {
            access = "protected";
        } else if (methodDoc.isPublic()) {
            access = "public";
        }
        atts.addAttribute(this.xmlns, this.localName, "access", "String", access);
        String extensibility = "default";
        if (methodDoc.isAbstract()) {
            extensibility = "abstract";
        } else if (methodDoc.isFinal()) {
            extensibility = "final";
        }
        atts.addAttribute(this.xmlns, this.localName, "extensiblity", "String", extensibility);
        atts.addAttribute(this.xmlns, this.localName, "native", "String", "" + methodDoc.isNative());
        atts.addAttribute(this.xmlns, this.localName, "synthetic", "String", "" + methodDoc.isSynthetic());
        atts.addAttribute(this.xmlns, this.localName, "static", "String", "" + methodDoc.isStatic());
        atts.addAttribute(this.xmlns, this.localName, "synchronized", "String", "" + methodDoc.isSynchronized());
        this.cm.startElement(this.xmlns, this.localName, "method", atts);
        this.docXML((Doc)methodDoc);
        this.returnsXML(methodDoc.returnType());
        Parameter[] parameterArray = methodDoc.parameters();
        int i = 0;
        while (i < parameterArray.length) {
            this.parameterXML(parameterArray[i]);
            ++i;
        }
        this.throwsXML((ExecutableMemberDoc)methodDoc);
        this.cm.endElement(this.xmlns, this.localName, "method");
    }

    private void returnsXML(Type type) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "dimension", "String", type.dimension());
        this.cm.startElement(this.xmlns, this.localName, "returns", atts);
        this.createTypeRef(type);
        this.cm.endElement(this.xmlns, this.localName, "returns");
    }

    private void parameterXML(Parameter parameter) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", parameter.name());
        boolean isFinal = false;
        Type type = parameter.type();
        if (type.asClassDoc() == null) {
            isFinal = true;
        }
        atts.addAttribute(this.xmlns, this.localName, "final", "String", "" + isFinal);
        atts.addAttribute(this.xmlns, this.localName, "dimension", "String", parameter.type().dimension());
        this.cm.startElement(this.xmlns, this.localName, "parameter", atts);
        this.createTypeRef(parameter.type());
        this.cm.endElement(this.xmlns, this.localName, "parameter");
    }

    private void docXML(Doc doc) throws SAXException {
        Tag[] tags;
        String commentText = "";
        boolean createDoc = false;
        commentText = doc.commentText();
        if (!commentText.equals("")) {
            createDoc = true;
        }
        if ((tags = doc.tags()).length > 0) {
            createDoc = true;
        }
        if (createDoc) {
            this.cm.startElement(this.xmlns, this.localName, "doc", this.emptyAtts);
            if (!commentText.equals("")) {
                this.cm.characters(commentText.toCharArray(), 0, commentText.length());
            }
            int i = 0;
            while (i < tags.length) {
                this.tagXML(tags[i]);
                ++i;
            }
            this.cm.endElement(this.xmlns, this.localName, "doc");
        }
    }

    private void tagXML(Tag tag) throws SAXException {
        String name = tag.name().substring(1) + "tag";
        if (!tag.text().equals("")) {
            this.cm.startElement(this.xmlns, this.localName, name, this.emptyAtts);
            this.cm.characters(tag.text().toCharArray(), 0, tag.text().length());
            this.cm.endElement(this.xmlns, this.localName, name);
        }
    }

    public static boolean start(RootDoc root) {
        try {
            new XMLDoclet(root);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    private void readOptions(RootDoc root) {
        String[][] options = root.options();
        int i = 0;
        while (i < options.length) {
            String[] opt = options[i];
            if (opt[0].equals("-d")) {
                this.targetFileName = opt[1] + "/javadoc.xml";
            }
            if (opt[0].equals("-encoding")) {
                this.encodingFormat = opt[1];
            }
            ++i;
        }
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-encoding")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundEncodingOption = false;
        boolean foundDirOption = false;
        int i = 0;
        while (i < options.length) {
            String[] opt = options[i];
            if (opt[0].equals("-d")) {
                if (foundDirOption) {
                    reporter.printError("Only one -d option allowed.");
                    return false;
                }
                foundDirOption = true;
            }
            if (opt[0].equals("-encoding")) {
                if (foundEncodingOption) {
                    reporter.printError("Only one -encoding option allowed.");
                    return false;
                }
                foundEncodingOption = true;
            }
            ++i;
        }
        if (!foundDirOption) {
            reporter.printError("Usage: javadoc -d <directory> -doclet TagXMLDoclet ...");
            return false;
        }
        return true;
    }
}

