/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.tags.BaseTagSupport;
import org.apache.maven.project.Resource;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class CopyResources
extends BaseTagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$jelly$tags$BaseTagSupport == null ? (class$org$apache$maven$jelly$tags$BaseTagSupport = CopyResources.class$("org.apache.maven.jelly.tags.BaseTagSupport")) : class$org$apache$maven$jelly$tags$BaseTagSupport));
    private List resources;
    private String todir;
    static /* synthetic */ Class class$org$apache$maven$jelly$tags$BaseTagSupport;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.resources == null || this.todir == null) {
            log.warn((Object)"resources or todir was null");
            return;
        }
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            String directoryName = resource.getDirectory();
            File directory = new File(directoryName);
            if (directory.exists() && directory.isDirectory() && directory.canRead()) {
                StringBuffer targetDirectoryBuffer = new StringBuffer(this.todir);
                String targetPath = resource.getTargetPath();
                if (targetPath != null && !targetPath.trim().equals("")) {
                    targetDirectoryBuffer.append('/').append(targetPath);
                }
                File targetDirectory = new File(targetDirectoryBuffer.toString());
                Copy copyTask = new Copy();
                copyTask.setProject((Project)this.getMavenContext().getAntProject());
                copyTask.setTodir(targetDirectory);
                copyTask.setFiltering(resource.getFiltering());
                copyTask.setOverwrite(resource.getFiltering());
                FileSet fileSet = new FileSet();
                fileSet.setDir(directory);
                if (resource.getIncludes().isEmpty()) {
                    PatternSet.NameEntry entry = fileSet.createInclude();
                    entry.setName("**/**");
                }
                Iterator incIter = resource.getIncludes().iterator();
                while (incIter.hasNext()) {
                    String include = (String)incIter.next();
                    PatternSet.NameEntry entry = fileSet.createInclude();
                    entry.setName(include);
                }
                Iterator incIter2 = resource.getExcludes().iterator();
                while (incIter2.hasNext()) {
                    String exclude = (String)incIter2.next();
                    PatternSet.NameEntry entry = fileSet.createExclude();
                    entry.setName(exclude);
                }
                copyTask.addFileset(fileSet);
                copyTask.execute();
                continue;
            }
            log.debug((Object)"todir is either not a directory, not writable or not there");
        }
    }

    public void setResources(List list) {
        this.resources = list;
    }

    public void setTodir(String string) {
        this.todir = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

