/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginCacheManager
extends DefaultHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$PluginCacheManager == null ? (class$org$apache$maven$plugin$PluginCacheManager = PluginCacheManager.class$("org.apache.maven.plugin.PluginCacheManager")) : class$org$apache$maven$plugin$PluginCacheManager));
    private static final Log sessionLog = LogFactory.getLog((Class)(class$org$apache$maven$MavenSession == null ? (class$org$apache$maven$MavenSession = PluginCacheManager.class$("org.apache.maven.MavenSession")) : class$org$apache$maven$MavenSession));
    public static final String PLUGINS_CACHE = "plugins.cache";
    public static final String GOALS_CACHE = "goals.cache";
    public static final String CALLBACKS_CACHE = "callbacks.cache";
    public static final String DYNAMIC_TAGLIBS_CACHE = "dynatag.cache";
    public static final String PLUGIN_DYNATAG_DEPS_CACHE = "plugin-dynatag-deps.cache";
    private File unpackedPluginsDir;
    private File pluginScript;
    private String pluginScriptDirectory;
    private String pluginName;
    private Properties goalCache = new Properties();
    private Properties pluginCache = new Properties();
    private Properties dynaTagLibCache = new Properties();
    private Properties callbackCache = new Properties();
    private Properties pluginDynaTagDepsCache = new Properties();
    private Set pluginGoals = new HashSet();
    private Set dynaTagLibDecls = new HashSet();
    private boolean clear = true;
    static /* synthetic */ Class class$org$apache$maven$plugin$PluginCacheManager;
    static /* synthetic */ Class class$org$apache$maven$MavenSession;

    public PluginCacheManager() {
    }

    public PluginCacheManager(boolean clear) {
        this.clear = clear;
    }

    public void setGoalCache(Properties goalCache) {
        this.goalCache = goalCache;
    }

    public Properties getGoalCache() {
        return this.goalCache;
    }

    public void setPluginCache(Properties pluginCache) {
        this.pluginCache = pluginCache;
    }

    public Properties getPluginCache() {
        return this.pluginCache;
    }

    public void setDynaTagLibCache(Properties dynamicTagLibCache) {
        this.dynaTagLibCache = dynamicTagLibCache;
    }

    public Properties getDynaTagLibCache() {
        return this.dynaTagLibCache;
    }

    public void setCallbackCache(Properties callbackCache) {
        this.callbackCache = callbackCache;
    }

    public Properties getCallbackCache() {
        return this.callbackCache;
    }

    public void setPluginScript(File pluginScript) {
        this.pluginScript = pluginScript;
        this.pluginName = this.pluginScriptDirectory = pluginScript.getParentFile().getName();
        if (this.clear) {
            this.pluginGoals.clear();
            this.dynaTagLibDecls.clear();
        }
    }

    public File getPluginScript() {
        return this.pluginScript;
    }

    public void setUnpackedPluginsDir(File unpackedPluginsDir) {
        this.unpackedPluginsDir = unpackedPluginsDir;
    }

    public File getUnpackedPluginsDir() {
        return this.unpackedPluginsDir;
    }

    public void setPluginDynaTagDepsCache(Properties pluginDynaTagDepsCache) {
        this.pluginDynaTagDepsCache = pluginDynaTagDepsCache;
    }

    public Properties getPluginDynaTagDepsCache() {
        return this.pluginDynaTagDepsCache;
    }

    public Set getDynaTagLibDecls() {
        return this.dynaTagLibDecls;
    }

    public void parse() {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            InputSource is = new InputSource(new FileInputStream(this.getPluginScript()));
            parser.parse(is, (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            sessionLog.error((Object)("An XML error occurred parsing the file '" + this.getPluginScript().getAbsolutePath() + "' plugin"), (Throwable)e);
        }
        catch (Exception e) {
            sessionLog.error((Object)("An unexpected error occurred parsing the file '" + this.getPluginScript().getAbsolutePath() + "'"), (Throwable)e);
        }
    }

    public void saveCache() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving caches to " + this.getUnpackedPluginsDir().getAbsolutePath()));
        }
        this.storeProperties(this.getPluginCache(), PLUGINS_CACHE, "plugins cache");
        this.storeProperties(this.getGoalCache(), GOALS_CACHE, "goals cache");
        this.storeProperties(this.getCallbackCache(), CALLBACKS_CACHE, "callbacks cache");
        this.storeProperties(this.getDynaTagLibCache(), DYNAMIC_TAGLIBS_CACHE, "taglibs cache");
        this.storeProperties(this.getPluginDynaTagDepsCache(), PLUGIN_DYNATAG_DEPS_CACHE, "plugin deps cache");
    }

    private void storeProperties(Properties properties, String name, String header) throws FileNotFoundException, IOException {
        File file = new File(this.getUnpackedPluginsDir(), name);
        FileOutputStream stream = new FileOutputStream(file);
        properties.store(stream, header);
        stream.close();
    }

    private Properties loadProperties(String name) {
        Properties properties = new Properties();
        File file = new File(this.getUnpackedPluginsDir(), name);
        try {
            FileInputStream stream = new FileInputStream(file);
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            log.debug((Object)"IOException reading cache, possibly not there", (Throwable)e);
        }
        return properties;
    }

    void loadCache() {
        this.pluginCache = this.loadProperties(PLUGINS_CACHE);
        this.goalCache = this.loadProperties(GOALS_CACHE);
        this.callbackCache = this.loadProperties(CALLBACKS_CACHE);
        this.dynaTagLibCache = this.loadProperties(DYNAMIC_TAGLIBS_CACHE);
        this.pluginDynaTagDepsCache = this.loadProperties(PLUGIN_DYNATAG_DEPS_CACHE);
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (!(uri.startsWith("jelly:") || uri.startsWith("dummy") || uri.equals(""))) {
            this.dynaTagLibDecls.add(uri);
            String commaSeperatedList = this.pluginDynaTagDepsCache.getProperty(this.pluginName);
            if (commaSeperatedList != null) {
                StringTokenizer tokens = new StringTokenizer(commaSeperatedList, ",");
                while (tokens.hasMoreTokens()) {
                    if (!tokens.nextToken().equals(uri)) continue;
                    return;
                }
                commaSeperatedList = commaSeperatedList + ',' + uri;
            } else {
                commaSeperatedList = uri;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching Taglib Uri --> " + uri));
            }
            this.pluginDynaTagDepsCache.setProperty(this.pluginName, commaSeperatedList);
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        if (rawName.equals("goal")) {
            String name = StringUtils.deleteWhitespace((String)attributes.getValue("name"));
            String prereqs = attributes.getValue("prereqs");
            String description = attributes.getValue("description");
            String goalProperty = description + ">";
            if (prereqs != null) {
                goalProperty = goalProperty + StringUtils.deleteWhitespace((String)prereqs);
            }
            this.goalCache.setProperty(name, goalProperty);
            this.pluginCache.setProperty(name, this.pluginScriptDirectory);
            this.pluginGoals.add(name);
        } else if (rawName.equals("preGoal")) {
            String name = attributes.getValue("name");
            String key = name + ".pre";
            this.callbackCache.setProperty(key, this.getCsvProperty(this.callbackCache, key, this.pluginScriptDirectory));
        } else if (rawName.equals("postGoal")) {
            String name = attributes.getValue("name");
            String key = name + ".post";
            this.callbackCache.setProperty(key, this.getCsvProperty(this.callbackCache, key, this.pluginScriptDirectory));
        } else if (localName.equals("taglib") && uri.equals("jelly:define")) {
            String tagLibUri = attributes.getValue("uri");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching Taglib Uri --> " + tagLibUri));
            }
            this.dynaTagLibCache.setProperty(tagLibUri, this.pluginScriptDirectory);
            if (this.dynaTagLibDecls.contains(tagLibUri)) {
                String prop = (String)((Hashtable)this.pluginDynaTagDepsCache).get(this.pluginName);
                int tl = tagLibUri.length();
                if (prop.indexOf(",") < 0) {
                    ((Hashtable)this.pluginDynaTagDepsCache).remove(this.pluginName);
                } else {
                    int i = prop.indexOf(tagLibUri + ",");
                    prop = i == 0 ? prop.substring(tl + 1) : (i > 0 ? prop.substring(0, i) + prop.substring(i + tl + 1) : prop.substring(0, prop.length() - tl - 1));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Caching Taglib Dependency --> " + prop));
                    }
                    ((Hashtable)this.pluginDynaTagDepsCache).put(this.pluginName, prop);
                }
            }
        }
    }

    private String getCsvProperty(Properties properties, String key, String newEntry) {
        String csvProperty = properties.getProperty(key);
        if (csvProperty == null) {
            return newEntry;
        }
        StringTokenizer st = new StringTokenizer(csvProperty, ",");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(newEntry)) continue;
            return csvProperty;
        }
        csvProperty = csvProperty + ',' + newEntry;
        return csvProperty;
    }

    public void warning(SAXParseException spe) {
        this.printParseError("Warning", spe);
    }

    public void error(SAXParseException spe) {
        this.printParseError("Error", spe);
    }

    public void fatalError(SAXParseException spe) {
        this.printParseError("Fatal Error", spe);
    }

    private final void printParseError(String type, SAXParseException spe) {
        System.err.println(type + " [line " + spe.getLineNumber() + ", row " + spe.getColumnNumber() + "]: " + spe.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

