/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import com.werken.forehead.Forehead;
import com.werken.werkz.Goal;
import com.werken.werkz.Session;
import com.werken.werkz.jelly.JellySession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.MavenException;
import org.apache.maven.MavenSession;
import org.apache.maven.MavenUtils;
import org.apache.maven.NoGoalException;
import org.apache.maven.UnknownGoalException;
import org.apache.maven.jelly.JellyUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginCacheManager;
import org.apache.maven.project.Project;
import org.apache.maven.util.Expand;

public class PluginManager
extends AbstractMavenComponent {
    public static final String PLUGIN_SCRIPT_NAME = "plugin.jelly";
    public static final String PLUGIN_PROPERTIES_NAME = "plugin.properties";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$PluginManager == null ? (class$org$apache$maven$plugin$PluginManager = PluginManager.class$("org.apache.maven.plugin.PluginManager")) : class$org$apache$maven$plugin$PluginManager));
    private static final String GLOBAL_SESSION_KEY = "maven.session.global";
    private File pluginsDir;
    private File unpackedPluginsDir;
    private Set loadedPlugins;
    private boolean initialized = false;
    private MavenSession mavenSession;
    private PluginCacheManager cacheManager;
    private PluginCacheManager transientCacheManager;
    static /* synthetic */ Class class$org$apache$maven$plugin$PluginManager;

    public PluginManager(MavenSession session) {
        this.mavenSession = session;
        this.loadedPlugins = new HashSet();
        this.cacheManager = new PluginCacheManager(true);
        this.transientCacheManager = new PluginCacheManager(true);
    }

    public Set getGoalNames() {
        return ((Hashtable)this.cacheManager.getGoalCache()).keySet();
    }

    public String getGoalDescription(String name) {
        String value = this.cacheManager.getGoalCache().getProperty(name);
        if (value == null || value.startsWith("null>")) {
            return null;
        }
        String description = value.substring(0, value.indexOf(">"));
        return description;
    }

    public void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Plugins!");
        }
        this.setPluginsDir(new File(this.mavenSession.getRootContext().getMavenHome(), "plugins"));
        this.setUnpackedPluginsDir(new File(this.mavenSession.getRootContext().getUnpackedPluginsDir()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set plugin source directory to " + this.getPluginsDir().getAbsolutePath()));
            log.debug((Object)("Set plugin cache directory to " + this.getUnpackedPluginsDir().getAbsolutePath()));
        }
        this.cacheManager.loadCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unpacking plugins from directory --> " + this.getPluginsDir().getAbsolutePath()));
        }
        this.expandPluginJars();
        this.cachePlugins();
        this.initialized = true;
        log.debug((Object)"Finished initializing Plugins!");
    }

    private void cachePlugins() throws Exception {
        File[] files = this.getUnpackedPluginsDir().listFiles();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing unpacked plugins in " + this.getUnpackedPluginsDir().getAbsolutePath()));
        }
        int i = 0;
        while (i < files.length) {
            String directory;
            if (files[i].isDirectory() && !this.isCached(directory = files[i].getName())) {
                try {
                    this.cachePlugin(files[i].getName());
                }
                catch (Exception e) {
                    log.error((Object)this.getMessage("plugin.loading.error", files[i].getName()));
                    e.printStackTrace();
                }
            }
            ++i;
        }
        this.saveCache();
    }

    private void expandPluginJars() throws MavenException {
        File[] files = this.getPluginsDir().listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(".jar")) {
                String directory = files[i].getName();
                directory = directory.substring(0, directory.indexOf(".jar"));
                File unzipDir = new File(this.getUnpackedPluginsDir(), directory);
                if (!unzipDir.exists() || files[i].lastModified() > unzipDir.lastModified()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unpacking '" + directory + "' plugin to directory --> " + unzipDir.getAbsolutePath()));
                    }
                    this.invalidateCache(directory);
                    try {
                        Expand unzipper = new Expand();
                        unzipper.setSrc(files[i]);
                        unzipper.setDest(unzipDir);
                        unzipper.execute();
                    }
                    catch (IOException e) {
                        throw new MavenException("Unable to extract plugin: " + files[i], e);
                    }
                }
            }
            ++i;
        }
    }

    public void attainGoals(Project project) throws UnknownGoalException, Exception {
        project.verifyDependencies();
        project.processDependencies();
        if (project.hasParent()) {
            project.loadJellyScript(project.parentMavenXml());
        }
        if (project.getFile() != null) {
            File mavenXmlFile = new File(project.getFile().getParentFile(), "maven.xml");
            this.loadJellyScript(mavenXmlFile, project);
        }
        if (project.getGoalNames().size() == 0) {
            if (project.getContext().getWerkzProject() == null) {
                throw new NoGoalException("No goal specified and no project.xml found.");
            }
            String defaultGoalName = project.getContext().getWerkzProject().getDefaultGoalName();
            if (defaultGoalName != null) {
                project.getGoalNames().add(defaultGoalName);
            }
        }
        Iterator i = project.getGoalNames().iterator();
        while (i.hasNext()) {
            String goalName = (String)i.next();
            this.prepForGoal(goalName, project);
            Goal eachGoal = project.getContext().getWerkzProject().getGoal(goalName);
            if (eachGoal != null) continue;
            throw new UnknownGoalException(goalName);
        }
        JellySession session = new JellySession(project.getContext().getXMLOutput());
        Thread.currentThread().setContextClassLoader(null);
        project.getContext().setVariable(GLOBAL_SESSION_KEY, session);
        Iterator i2 = project.getGoalNames().iterator();
        while (i2.hasNext()) {
            String eachGoalName = (String)i2.next();
            Goal eachGoal = project.getContext().getWerkzProject().getGoal(eachGoalName);
            eachGoal.attain((Session)session);
        }
    }

    public void loadJellyScript(File jellyScript, Project project) throws Exception {
        if (!jellyScript.exists()) {
            return;
        }
        HashSet originalGoals = new HashSet(project.getContext().getWerkzProject().getGoals());
        Iterator i = originalGoals.iterator();
        while (i.hasNext()) {
            Goal eachGoal = (Goal)i.next();
            if (eachGoal.getAction() != null) continue;
            i.remove();
        }
        this.transientCacheManager.setPluginScript(jellyScript);
        this.transientCacheManager.parse();
        Iterator i2 = this.transientCacheManager.getDynaTagLibDecls().iterator();
        while (i2.hasNext()) {
            this.prepDynamicTagLib((String)i2.next(), project);
        }
        JellyUtils.runScript(jellyScript, project.getFile().getParentFile().toURL(), (JellyContext)project.getContext(), project.getContext().getXMLOutput());
    }

    public void prepForGoal(String initialGoalToPrep, Project project) throws Exception {
        LinkedList<String> goalsToPrep = new LinkedList<String>();
        HashSet<String> seen = new HashSet<String>();
        String goalToPrep = null;
        goalsToPrep.add(initialGoalToPrep);
        while (!goalsToPrep.isEmpty()) {
            goalToPrep = (String)goalsToPrep.removeFirst();
            if (seen.contains(goalToPrep)) continue;
            seen.add(goalToPrep);
            String spec = this.transientCacheManager.getPluginCache().getProperty(goalToPrep);
            if (spec == null && (spec = this.cacheManager.getPluginCache().getProperty(goalToPrep)) != null) {
                this.prepForCallbacks(goalToPrep, project);
                this.loadPlugin(spec, project);
            }
            List prereqs = this.getPrereqs(goalToPrep);
            goalsToPrep.addAll(prereqs);
        }
    }

    void prepForCallbacks(String goalName, Project project) throws Exception {
        if (((Hashtable)this.cacheManager.getCallbackCache()).containsKey(goalName + ".pre")) {
            this.loadPlugins(this.cacheManager.getCallbackCache().getProperty(goalName + ".pre"), project);
        }
        if (((Hashtable)this.cacheManager.getCallbackCache()).containsKey(goalName + ".post")) {
            this.loadPlugins(this.cacheManager.getCallbackCache().getProperty(goalName + ".post"), project);
        }
    }

    void prepDynaTagLibs(String pluginName, Project project) throws Exception {
        String depPlugins = this.cacheManager.getPluginDynaTagDepsCache().getProperty(pluginName);
        if (depPlugins == null) {
            return;
        }
        String[] list = StringUtils.split((String)depPlugins, (String)",");
        int i = 0;
        while (i < list.length) {
            this.prepDynamicTagLib(list[i], project);
            ++i;
        }
    }

    void prepDynamicTagLib(String uri, Project project) throws Exception {
        String depPlugin = this.cacheManager.getDynaTagLibCache().getProperty(uri);
        if (depPlugin == null) {
            return;
        }
        this.loadPlugin(depPlugin, project);
    }

    List getPrereqs(String name) {
        String spec = this.transientCacheManager.getGoalCache().getProperty(name);
        if (spec == null) {
            spec = this.cacheManager.getGoalCache().getProperty(name);
        }
        if (spec == null) {
            return Collections.EMPTY_LIST;
        }
        int splitLoc = spec.indexOf(">");
        if (splitLoc < 0 || splitLoc + 1 == spec.length()) {
            return Collections.EMPTY_LIST;
        }
        String prereqSpec = spec.substring(splitLoc + 1);
        StringTokenizer tokens = new StringTokenizer(prereqSpec, ",");
        ArrayList<String> prereqs = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            prereqs.add(tokens.nextToken());
        }
        return prereqs;
    }

    public void loadPlugin(String name, Project project) throws Exception {
        if (this.isLoaded(project, name)) {
            return;
        }
        File pluginScript = this.getPluginScript(name);
        if (!pluginScript.exists()) {
            return;
        }
        this.prepDynaTagLibs(name, project);
        File unpackedPluginDir = this.getUnpackedPluginDir(name);
        Forehead.getInstance().getClassLoader("root.maven").addURL(unpackedPluginDir.toURL());
        Project pluginProject = MavenUtils.getProject(new File(unpackedPluginDir, "project.xml"), project.getContext(), false);
        pluginProject.verifyDependencies();
        pluginProject.processDependencies();
        MavenJellyContext pluginContext = new MavenJellyContext(project.getContext());
        MavenUtils.integrateMapInContext(this.getPluginProperties(unpackedPluginDir), pluginContext);
        pluginContext.setVariable("plugin", pluginProject);
        pluginContext.setVariable("plugin.dir", unpackedPluginDir);
        pluginContext.setVariable("plugin.resources", new File(unpackedPluginDir, "plugin-resources"));
        project.addPluginContext(pluginProject.getId(), pluginContext);
        JellyUtils.runScript(pluginScript, unpackedPluginDir.toURL(), (JellyContext)pluginContext, pluginContext.getXMLOutput());
        if (project.getContext().getWerkzProject() == null) {
            project.getContext().setWerkzProject(pluginContext.getWerkzProject());
        }
        this.loadedPlugins.add(project.hashCode() + name);
    }

    void loadPlugins(String names, Project project) throws Exception {
        StringTokenizer tokens = new StringTokenizer(names, ",");
        while (tokens.hasMoreTokens()) {
            this.loadPlugin(tokens.nextToken(), project);
        }
    }

    void cachePlugin(String name) throws Exception {
        log.debug((Object)("Processing Plugin: " + name));
        File pluginScript = this.getPluginScript(name);
        if (pluginScript.exists()) {
            this.cacheManager.setPluginScript(pluginScript);
            this.cacheManager.parse();
        }
    }

    void saveCache() throws Exception {
        this.cacheManager.saveCache();
    }

    void invalidateCache(String pluginName) {
        Iterator i = ((Hashtable)this.cacheManager.getGoalCache()).keySet().iterator();
        while (i.hasNext()) {
            String eachGoal = (String)i.next();
            if (!this.cacheManager.getPluginCache().getProperty(eachGoal).equals(pluginName)) continue;
            i.remove();
            ((Hashtable)this.cacheManager.getPluginCache()).remove(eachGoal);
            ((Hashtable)this.cacheManager.getCallbackCache()).remove(eachGoal + ".pre");
            ((Hashtable)this.cacheManager.getCallbackCache()).remove(eachGoal + ".post");
        }
    }

    boolean isCached(String pluginName) {
        return ((Hashtable)this.cacheManager.getPluginCache()).contains(pluginName);
    }

    boolean isGoalCached(String name) {
        return ((Hashtable)this.cacheManager.getGoalCache()).containsKey(name);
    }

    Set getTagLibsCache() {
        return ((Hashtable)this.cacheManager.getDynaTagLibCache()).keySet();
    }

    boolean isLoaded(Project project, String name) {
        return this.loadedPlugins.contains(project.hashCode() + name);
    }

    Properties getPluginProperties(File unpackedPluginDir) throws IOException {
        File propsFile = new File(unpackedPluginDir, PLUGIN_PROPERTIES_NAME);
        if (!propsFile.exists()) {
            return null;
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propsFile);
        props.load(in);
        in.close();
        return props;
    }

    File getUnpackedPluginDir(String pluginName) {
        return new File(this.getUnpackedPluginsDir(), pluginName);
    }

    File getPluginScript(String pluginName) {
        return new File(this.getUnpackedPluginDir(pluginName), PLUGIN_SCRIPT_NAME);
    }

    void setPluginsDir(File dir) {
        this.pluginsDir = dir;
    }

    File getPluginsDir() {
        return this.pluginsDir;
    }

    void setUnpackedPluginsDir(File dir) {
        this.unpackedPluginsDir = dir;
        this.cacheManager.setUnpackedPluginsDir(this.unpackedPluginsDir);
    }

    File getUnpackedPluginsDir() {
        return this.unpackedPluginsDir;
    }

    public void installPlugin(Project project, File file) throws Exception {
        FileUtils.copyFileToDirectory((File)file, (File)this.getPluginsDir());
        String pluginName = file.getCanonicalFile().getName();
        pluginName = pluginName.substring(0, pluginName.indexOf(".jar"));
        if (!this.isLoaded(project, pluginName)) {
            String newFileName = this.getPluginsDir().getCanonicalPath() + File.separator + file.getCanonicalFile().getName();
            Expand unzipper = new Expand();
            unzipper.setSrc(new File(newFileName));
            File unzipDir = new File(this.getUnpackedPluginsDir(), pluginName);
            unzipper.setDest(unzipDir);
            unzipper.execute();
            this.loadPlugin(pluginName, project);
            this.cachePlugin(pluginName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

