/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenUtils;
import org.apache.maven.project.Dependency;
import org.apache.maven.repository.Artifact;
import org.apache.maven.util.MD5Sum;
import org.apache.maven.verifier.ChecksumVerificationException;

public abstract class AbstractArtifact
implements Artifact {
    private Log log = LogFactory.getLog((Class)(class$org$apache$maven$repository$AbstractArtifact == null ? (class$org$apache$maven$repository$AbstractArtifact = AbstractArtifact.class$("org.apache.maven.repository.AbstractArtifact")) : class$org$apache$maven$repository$AbstractArtifact));
    protected static final String ps = File.separator;
    private Dependency dependency;
    private String path;
    static /* synthetic */ Class class$org$apache$maven$repository$AbstractArtifact;

    public AbstractArtifact(Dependency dependency) {
        this.dependency = dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        if (this.path == null) {
            return this.generatePath();
        }
        return this.path;
    }

    public String generatePath() {
        return ps + this.getDependency().getArtifactDirectory() + ps + this.getDependency().getType() + "s" + ps + this.getDependency().getArtifact();
    }

    public String getUrlPath() {
        return "/" + this.getDependency().getArtifactDirectory() + "/" + this.getDependency().getType() + "s" + "/" + this.getDependency().getArtifact();
    }

    public String getChecksumUrl() {
        return "/" + this.getDependency().getArtifactDirectory() + "/" + this.getDependency().getType() + "s" + "/" + this.getDependency().getArtifact() + ".md5";
    }

    public String getName() {
        return this.getDependency().getArtifact();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isSnapshot() {
        return this.getDependency().getArtifact().indexOf("SNAPSHOT") > 0;
    }

    public File getFile() {
        return new File(this.getPath());
    }

    public void verify() throws ChecksumVerificationException {
        File checksumFile = new File(this.getFile() + ".md5");
        if (!checksumFile.exists()) {
            return;
        }
        String actualChecksum = null;
        MD5Sum md5 = null;
        try {
            md5 = new MD5Sum();
            md5.setFile(this.getFile());
            md5.execute();
            actualChecksum = this.fileRead(checksumFile);
            actualChecksum = actualChecksum.substring(0, actualChecksum.length() - 1);
        }
        catch (Exception e) {
            return;
        }
        this.log.debug((Object)("Actual checksum: '" + actualChecksum + "'"));
        this.log.debug((Object)("MD5 checksum: '" + md5.getChecksum() + "'"));
        if (!actualChecksum.equals(md5.getChecksum())) {
            throw new ChecksumVerificationException(MavenUtils.getMessage("checksum.verification.error", this.getPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    String fileRead(File file) throws IOException {
        int count;
        StringBuffer buf = new StringBuffer();
        FileInputStream in = new FileInputStream(file);
        byte[] b = new byte[512];
        while ((count = in.read(b)) > 0) {
            void var4_5;
            buf.append(new String(b, 0, (int)var4_5));
        }
        in.close();
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

