/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.grant;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.grant.PropsHandler;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.JavaEnvUtils;

public class DefaultPropsHandler
implements PropsHandler {
    protected Map properties;
    protected Map userProperties = new HashMap();
    protected Map inheritedProperties = new HashMap();

    public DefaultPropsHandler() {
        this.properties = new HashMap();
    }

    public DefaultPropsHandler(Map map) {
        this.properties = map;
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void setUserProperty(String string, String string2) {
        this.userProperties.put(string, string2);
        this.setProperty(string, string2);
    }

    public void setNewProperty(String string, String string2) {
        if (this.getProperty(string) == null) {
            this.setProperty(string, string2);
        }
    }

    public void setInheritedProperty(String string, String string2) {
        this.inheritedProperties.put(string, string2);
        this.setUserProperty(string, string2);
    }

    public void setPropertyIfUndefinedByUser(String string, String string2) {
        if (!this.getUserProperties().contains(string)) {
            this.setProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.properties.get(string);
    }

    public String getUserProperty(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.userProperties.get(string);
    }

    public Hashtable getProperties() {
        return new Hashtable(this.properties);
    }

    public Hashtable getUserProperties() {
        return new Hashtable(this.userProperties);
    }

    public Hashtable getInheritedProperties() {
        return new Hashtable(this.inheritedProperties);
    }

    public void copyUserProperties(Project project) {
        Hashtable hashtable = this.getUserProperties();
        Hashtable hashtable2 = this.getInheritedProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (hashtable2.contains(k)) continue;
            Object v = hashtable.get(k);
            project.setUserProperty(k.toString(), v.toString());
        }
    }

    public void copyInheritedProperties(Project project) {
        Hashtable hashtable = this.getInheritedProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (project.getUserProperty(string) != null) continue;
            Object v = hashtable.get(string);
            project.setInheritedProperty(string, v.toString());
        }
    }

    public void setSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = ((Hashtable)properties).get(k).toString();
            this.setPropertyIfUndefinedByUser(k.toString(), string);
        }
    }

    public void setJavaVersionProperty() {
        String string = JavaEnvUtils.getJavaVersion();
        this.setPropertyIfUndefinedByUser("ant.java.version", string);
    }
}

