/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.maven.jxr.pacman.PackageType;
import org.apache.oro.text.perl.Perl5Util;

public class DirectoryIndexer {
    static final String INDEX = "package-summary.html";
    private String root;
    private PackageManager packageManager;
    private String templateDir;
    private String windowTitle;
    private String docTitle;
    private String bottom;

    public DirectoryIndexer(PackageManager packageManager, String root) {
        this.packageManager = packageManager;
        this.root = root;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setBottom(String bottom) {
        this.bottom = bottom;
    }

    public String getBottom() {
        return this.bottom;
    }

    public void process() throws Exception {
        Map info = this.getPackageInfo();
        JellyContext mainContext = new JellyContext();
        mainContext.setVariable("windowTitle", (Object)this.getWindowTitle());
        mainContext.setVariable("docTitle", (Object)this.getDocTitle());
        mainContext.setVariable("bottom", (Object)this.getBottom());
        mainContext.setVariable("info", (Object)info);
        this.doJellyFile("index", this.root, mainContext);
        this.doJellyFile("overview-frame", this.root, mainContext);
        this.doJellyFile("allclasses-frame", this.root, mainContext);
        this.doJellyFile("overview-summary", this.root, mainContext);
        Iterator iter = ((Map)info.get("allPackages")).values().iterator();
        while (iter.hasNext()) {
            Map pkgInfo = (Map)iter.next();
            JellyContext subContext = mainContext.newJellyContext();
            subContext.setVariable("pkgInfo", (Object)pkgInfo);
            String outDir = this.root + "/" + (String)pkgInfo.get("dir");
            this.doJellyFile("package-summary", outDir, subContext);
            this.doJellyFile("package-frame", outDir, subContext);
        }
    }

    private void doJellyFile(String templateName, String outDir, JellyContext context) throws Exception {
        String outFile = outDir + "/" + templateName + ".html";
        String templateFileName = this.getTemplateDir() + "/" + templateName + ".jelly";
        File templateFile = new File(templateFileName);
        File theFile = new File(outFile);
        File dir = theFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(outFile);
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)out, (boolean)false);
        context.runScript(templateFile, xmlOutput);
        xmlOutput.flush();
        ((OutputStream)out).close();
    }

    private Map getPackageInfo() {
        TreeMap allPackages = new TreeMap();
        TreeMap allClasses = new TreeMap();
        Perl5Util perl = new Perl5Util();
        Enumeration packages = this.packageManager.getPackageTypes();
        while (packages.hasMoreElements()) {
            PackageType pkg = (PackageType)packages.nextElement();
            String pkgName = pkg.getName();
            String pkgDir = perl.substitute("s/\\./\\//g", pkgName);
            String rootRef = perl.substitute("s/[^\\.]*(\\.|$)/\\.\\.\\//g", pkgName);
            if (pkgName.length() == 0) {
                pkgName = "(default package)";
                pkgDir = ".";
                rootRef = "./";
            }
            TreeMap pkgClasses = new TreeMap();
            Enumeration classes = pkg.getClassTypes();
            while (classes.hasMoreElements()) {
                ClassType clazz = (ClassType)classes.nextElement();
                String className = clazz.getName();
                HashMap<String, String> classInfo = new HashMap<String, String>();
                classInfo.put("name", className);
                classInfo.put("dir", pkgDir);
                pkgClasses.put(className, classInfo);
                allClasses.put(className, classInfo);
            }
            HashMap<String, Object> pkgInfo = new HashMap<String, Object>();
            pkgInfo.put("name", pkgName);
            pkgInfo.put("dir", pkgDir);
            pkgInfo.put("classes", pkgClasses);
            pkgInfo.put("rootRef", rootRef);
            allPackages.put(pkgName, pkgInfo);
        }
        HashMap info = new HashMap();
        info.put("allPackages", allPackages);
        info.put("allClasses", allClasses);
        return info;
    }
}

