/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCCheckout
extends ClearCase {
    private boolean m_Reserved = true;
    private String m_Out = null;
    private boolean m_Ndata = false;
    private String m_Branch = null;
    private boolean m_Version = false;
    private boolean m_Nwarn = false;
    private String m_Comment = null;
    private String m_Cfile = null;
    public static final String FLAG_RESERVED = "-reserved";
    public static final String FLAG_UNRESERVED = "-unreserved";
    public static final String FLAG_OUT = "-out";
    public static final String FLAG_NODATA = "-ndata";
    public static final String FLAG_BRANCH = "-branch";
    public static final String FLAG_VERSION = "-version";
    public static final String FLAG_NOWARN = "-nwarn";
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        if (this.getViewPath() == null) {
            this.setViewPath(aProj.getBaseDir().getPath());
        }
        commandLine.setExecutable(this.getClearToolCommand());
        commandLine.createArgument().setValue("checkout");
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getReserved()) {
            cmd.createArgument().setValue(FLAG_RESERVED);
        } else {
            cmd.createArgument().setValue(FLAG_UNRESERVED);
        }
        if (this.getOut() != null) {
            this.getOutCommand(cmd);
        } else if (this.getNoData()) {
            cmd.createArgument().setValue(FLAG_NODATA);
        }
        if (this.getBranch() != null) {
            this.getBranchCommand(cmd);
        } else if (this.getVersion()) {
            cmd.createArgument().setValue(FLAG_VERSION);
        }
        if (this.getNoWarn()) {
            cmd.createArgument().setValue(FLAG_NOWARN);
        }
        if (this.getComment() != null) {
            this.getCommentCommand(cmd);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(cmd);
        } else {
            cmd.createArgument().setValue(FLAG_NOCOMMENT);
        }
        cmd.createArgument().setValue(this.getViewPath());
    }

    public void setReserved(boolean reserved) {
        this.m_Reserved = reserved;
    }

    public boolean getReserved() {
        return this.m_Reserved;
    }

    public void setOut(String outf) {
        this.m_Out = outf;
    }

    public String getOut() {
        return this.m_Out;
    }

    public void setNoData(boolean ndata) {
        this.m_Ndata = ndata;
    }

    public boolean getNoData() {
        return this.m_Ndata;
    }

    public void setBranch(String branch) {
        this.m_Branch = branch;
    }

    public String getBranch() {
        return this.m_Branch;
    }

    public void setVersion(boolean version) {
        this.m_Version = version;
    }

    public boolean getVersion() {
        return this.m_Version;
    }

    public void setNoWarn(boolean nwarn) {
        this.m_Nwarn = nwarn;
    }

    public boolean getNoWarn() {
        return this.m_Nwarn;
    }

    public void setComment(String comment) {
        this.m_Comment = comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String cfile) {
        this.m_Cfile = cfile;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    private void getOutCommand(Commandline cmd) {
        if (this.getOut() != null) {
            cmd.createArgument().setValue(FLAG_OUT);
            cmd.createArgument().setValue(this.getOut());
        }
    }

    private void getBranchCommand(Commandline cmd) {
        if (this.getBranch() != null) {
            cmd.createArgument().setValue(FLAG_BRANCH);
            cmd.createArgument().setValue(this.getBranch());
        }
    }

    private void getCommentCommand(Commandline cmd) {
        if (this.getComment() != null) {
            cmd.createArgument().setValue(FLAG_COMMENT);
            cmd.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline cmd) {
        if (this.getCommentFile() != null) {
            cmd.createArgument().setValue(FLAG_COMMENTFILE);
            cmd.createArgument().setValue(this.getCommentFile());
        }
    }
}

