/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.j2ee;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.maven.j2ee.ValidationEvent;
import org.apache.maven.j2ee.ValidationListener;

public class ValidationFormatter
implements ValidationListener {
    private boolean usefile;
    private String file;
    private String type = "plain";
    public static final String PLAIN = "plain";
    public static final String XML = "xml";
    private PrintStream stream = System.out;

    private boolean isPlain() {
        return PLAIN.equals(this.getType());
    }

    private void printEventAsXML(ValidationEvent event, String eventName) {
        this.getStream().println("\t<" + eventName + ">");
        this.getStream().println("\t\t<source>");
        this.getStream().println("\t\t\t" + event.getSource());
        this.getStream().println("\t\t</source>");
        this.getStream().println("\t\t<subject>");
        this.getStream().println("\t\t\t" + event.getSubject());
        this.getStream().println("\t\t</subject>");
        this.getStream().println("\t\t<message>");
        this.getStream().println("\t\t\t" + event.getMessage());
        this.getStream().println("\t\t</message>");
        this.getStream().println("\t</" + eventName + ">");
    }

    private void printEvent(String type, ValidationEvent event) {
        this.getStream().println(event.getSubject() + " " + type + ": " + event.getMessage());
    }

    public void validationEnded(ValidationEvent event) {
        if (this.isPlain()) {
            this.printEvent("ended", event);
        } else {
            this.printEventAsXML(event, "ended");
            this.getStream().println("</validation-report>");
        }
    }

    public void validationError(ValidationEvent event) {
        if (this.isPlain()) {
            this.printEvent("error", event);
        } else {
            this.printEventAsXML(event, "error");
        }
    }

    public void validationStarted(ValidationEvent event) {
        if (this.isPlain()) {
            this.printEvent("started", event);
        } else {
            this.getStream().println("<?xml version=\"1.0\" ?>");
            this.getStream().println("<validation-report>");
            this.printEventAsXML(event, "started");
        }
    }

    public void validationWarning(ValidationEvent event) {
        if (this.isPlain()) {
            this.printEvent("warning", event);
        } else {
            this.printEventAsXML(event, "warning");
        }
    }

    public void validationInformation(ValidationEvent event) {
        if (this.isPlain()) {
            this.printEvent("info", event);
        } else {
            this.printEventAsXML(event, "info");
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) throws FileNotFoundException {
        this.file = file;
        File theFile = new File(file);
        File dir = theFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        this.stream = new PrintStream(fos);
    }

    public boolean isUsefile() {
        return this.usefile;
    }

    public void setUsefile(boolean usefile) {
        this.usefile = usefile;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

