/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.classloader;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.plexus.classloader.PlexusClassLoader;
import org.apache.plexus.classloader.ResourceManager;
import org.apache.plexus.logging.AbstractLogEnabled;
import org.apache.plexus.util.Expand;

public class DefaultResourceManager
extends AbstractLogEnabled
implements Configurable,
ResourceManager {
    private PlexusClassLoader plexusClassLoader;
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.plexusClassLoader = new PlexusClassLoader(classLoader);
    }

    public PlexusClassLoader getPlexusClassLoader() {
        return this.plexusClassLoader;
    }

    public DefaultResourceManager createChild(String id) {
        DefaultResourceManager child = new DefaultResourceManager();
        child.setClassLoader(this.getPlexusClassLoader());
        child.enableLogging(this.getLogger());
        return child;
    }

    public void addDirectoryResource(String directory) throws Exception {
        this.addDirectoryResource(new File(directory));
    }

    public void addDirectoryResource(File directory) throws Exception {
        this.getPlexusClassLoader().addURL(directory.toURL());
        this.getLogger().info("added directory resource; " + directory.getPath());
    }

    public void addJarResource(String jar) throws Exception {
        this.addJarResource(new File(jar));
    }

    public void addJarResource(File jar) throws Exception {
        this.getPlexusClassLoader().addURL(jar.toURL());
        this.getLogger().info("added jar resource: " + jar.getPath());
    }

    public void addComponentResourceJar(String component) throws Exception {
        this.addComponentResourceJar(new File(component));
    }

    public void addComponentResourceJar(File component) throws Exception {
        Expand expand = new Expand();
        expand.setSrc(component);
        expand.setDest(component.getParentFile());
        expand.setOverwrite(false);
        expand.execute();
    }

    public void addUrlResource(String url) throws Exception {
        this.addUrlResource(new URL(url));
    }

    public void addUrlResource(URL url) throws Exception {
        this.getPlexusClassLoader().addURL(url);
        this.getLogger().info("added url resource; " + url.toExternalForm());
    }

    public URL[] getURLs() {
        return this.getPlexusClassLoader().getURLs();
    }

    public InputStream getResourceAsStream(String resource) {
        return this.getPlexusClassLoader().getResourceAsStream(resource);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] resourceConfigs = configuration.getChildren();
        int i = 0;
        while (i < resourceConfigs.length) {
            try {
                if (resourceConfigs[i].getName().equals("directory")) {
                    this.addDirectoryResource(resourceConfigs[i].getValue());
                } else if (resourceConfigs[i].getName().equals("jar")) {
                    this.addJarResource(resourceConfigs[i].getValue());
                } else if (resourceConfigs[i].getName().equals("jar-repository")) {
                    this.addJarRepository(resourceConfigs[i].getValue());
                } else if (resourceConfigs[i].getName().equals("url")) {
                    this.addUrlResource(resourceConfigs[i].getValue());
                } else if (resourceConfigs[i].getName().equals("component")) {
                    this.addComponentResourceJar(resourceConfigs[i].getValue());
                } else {
                    this.getLogger().warn("unknown resource type: " + resourceConfigs[i].getName());
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("error configuring resource: " + resourceConfigs[i].getValue(), (Throwable)e);
            }
            ++i;
        }
    }

    public void addJarRepository(String repository) throws Exception {
        this.addJarRepository(new File(repository));
    }

    public void addJarRepository(File repository) throws Exception {
        if (repository.exists() && repository.isDirectory()) {
            File[] jars = repository.listFiles();
            int j = 0;
            while (j < jars.length) {
                if (jars[j].getAbsolutePath().endsWith(".jar")) {
                    this.addJarResource(jars[j]);
                }
                ++j;
            }
        }
    }
}

