/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.embed;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.plexus.DefaultPlexusContainer;
import org.apache.plexus.PlexusContainer;

public class Embedder {
    private PlexusContainer container;
    private String configuration;

    public void Embedder() throws Exception {
        this.container = new DefaultPlexusContainer();
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void addContextValue(Object key, Object value) {
        this.container.addContextValue(key, value);
    }

    public void run() throws Exception {
        this.container.setConfigurationResource(new InputStreamReader(this.findConfigurationInputStream()));
        this.container.initialize();
        this.container.start();
        this.container.dispose();
    }

    private InputStream findConfigurationInputStream() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configuration);
        if (is == null) {
            try {
                is = new FileInputStream(this.configuration);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new IllegalStateException("The specified configuration resource cannot be found: " + this.configuration);
        }
        return is;
    }
}

