/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.service.repository;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.plexus.service.repository.ComponentDescriptor;
import org.apache.plexus.service.repository.ComponentHousing;
import org.apache.plexus.service.repository.ComponentRepository;
import org.apache.plexus.service.repository.instance.InstanceManager;

public class ComponentManager {
    private ComponentDescriptor componentDescriptor;
    private ComponentDescriptor instanceManagerDescriptor;
    private InstanceManager instanceManager;
    private ClassLoader classLoader;
    private ComponentRepository componentRespository;

    public ComponentManager(ComponentDescriptor componentDescriptor, ComponentRepository componentRepository, ComponentDescriptor instanceManagerDescriptor, ClassLoader classLoader) {
        this.componentDescriptor = componentDescriptor;
        this.componentRespository = componentRepository;
        this.instanceManagerDescriptor = instanceManagerDescriptor;
        this.classLoader = classLoader;
    }

    public void initialize() throws Exception {
        Class<?> c = this.classLoader.loadClass(this.instanceManagerDescriptor.getImplementation());
        this.instanceManager = (InstanceManager)c.newInstance();
        this.instanceManager.setClassLoader(this.classLoader);
        this.instanceManager.setImplementation(this.componentDescriptor.getImplementation());
        this.instanceManager.setComponentManager(this);
        this.instanceManager.initialize();
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.componentDescriptor;
    }

    public void setComponentDescriptor(ComponentDescriptor serviceDescriptor) {
        this.componentDescriptor = serviceDescriptor;
    }

    public ComponentRepository getComponentRespository() {
        return this.componentRespository;
    }

    public void setComponentRespository(ComponentRepository componentRespository) {
        this.componentRespository = componentRespository;
    }

    public ComponentHousing getComponentHousing() throws ServiceException {
        try {
            return this.getInstanceManager().getInstance();
        }
        catch (Exception e) {
            throw new ServiceException("instance-manager", e.getMessage(), (Throwable)e);
        }
    }

    public InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    public void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

