/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.parser;

import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.ParserVisitor;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.util.Coercion;

public class ASTEQNode
extends SimpleNode {
    public ASTEQNode(int id) {
        super(id);
    }

    public ASTEQNode(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext pc) throws Exception {
        Object left = ((SimpleNode)this.jjtGetChild(0)).value(pc);
        Object right = ((SimpleNode)this.jjtGetChild(1)).value(pc);
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        if (left.getClass().equals(right.getClass())) {
            return new Boolean(left.equals(right));
        }
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            Double l = Coercion.coerceDouble(left);
            Double r = Coercion.coerceDouble(right);
            return new Boolean(l.equals(r));
        }
        if (left instanceof Number || right instanceof Number || left instanceof Character || right instanceof Character) {
            return new Boolean(Coercion.coerceLong(left).equals(Coercion.coerceLong(right)));
        }
        if (left instanceof Boolean || right instanceof Boolean) {
            return new Boolean(Coercion.coerceBoolean(left).equals(Coercion.coerceBoolean(right)));
        }
        if (left instanceof String || right instanceof String) {
            return new Boolean(left.toString().equals(right.toString()));
        }
        return new Boolean(left.equals(right));
    }
}

