/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.domain.basic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.MutableDirectedGraph;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedEdge;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.contract.Contract;
import org.apache.commons.graph.exception.GraphException;

public class DirectedGraphImpl
implements DirectedGraph,
WeightedGraph,
MutableDirectedGraph,
InvocationHandler {
    private Vertex root = null;
    private Set vertices = new HashSet();
    private Set edges = new HashSet();
    private List contracts = new ArrayList();
    private Map inbound = new HashMap();
    private Map outbound = new HashMap();
    private Map edgeSource = new HashMap();
    private Map edgeTarget = new HashMap();
    private Map edgeWeights = new HashMap();

    public DirectedGraphImpl() {
    }

    public DirectedGraphImpl(DirectedGraph dg) {
        Iterator v = dg.getVertices().iterator();
        while (v.hasNext()) {
            this.addVertexI((Vertex)v.next());
        }
        Iterator e = dg.getEdges().iterator();
        while (e.hasNext()) {
            Edge edge = (Edge)e.next();
            this.addEdgeI(edge, dg.getSource(edge), dg.getTarget(edge));
            if (!(dg instanceof WeightedGraph)) continue;
            this.setWeight(edge, ((WeightedGraph)((Object)dg)).getWeight(edge));
        }
    }

    public void addContract(Contract c) throws GraphException {
        c.setImpl(this);
        c.verify();
        this.contracts.add(c);
    }

    public void removeContract(Contract c) {
        this.contracts.remove(c);
    }

    public void setWeight(Edge e, double value) {
        if (this.edgeWeights.containsKey(e)) {
            this.edgeWeights.remove(e);
        }
        this.edgeWeights.put(e, new Double(value));
    }

    public Set getVertices() {
        return new HashSet(this.vertices);
    }

    public Set getVertices(Edge e) {
        HashSet RC = new HashSet();
        if (this.edgeSource.containsKey(e)) {
            RC.add(this.edgeSource.get(e));
        }
        if (this.edgeTarget.containsKey(e)) {
            RC.add(this.edgeTarget.get(e));
        }
        return RC;
    }

    public Set getEdges() {
        return new HashSet(this.edges);
    }

    public Set getEdges(Vertex v) {
        HashSet RC = new HashSet();
        if (this.inbound.containsKey(v)) {
            RC.addAll((Set)this.inbound.get(v));
        }
        if (this.outbound.containsKey(v)) {
            RC.addAll((Set)this.outbound.get(v));
        }
        return RC;
    }

    public Vertex getSource(Edge e) {
        return (Vertex)this.edgeSource.get(e);
    }

    public Vertex getTarget(Edge e) {
        return (Vertex)this.edgeTarget.get(e);
    }

    public Set getInbound(Vertex v) {
        if (this.inbound.containsKey(v)) {
            return new HashSet((Set)this.inbound.get(v));
        }
        return new HashSet();
    }

    public Set getOutbound(Vertex v) {
        if (this.outbound.containsKey(v)) {
            return new HashSet((Set)this.outbound.get(v));
        }
        return new HashSet();
    }

    private void addVertexI(Vertex v) throws GraphException {
        if (this.root == null) {
            this.root = v;
        }
        this.vertices.add(v);
    }

    public void addVertex(Vertex v) throws GraphException {
        Iterator conts = this.contracts.iterator();
        while (conts.hasNext()) {
            ((Contract)conts.next()).addVertex(v);
        }
        this.addVertexI(v);
    }

    private void removeVertexI(Vertex v) throws GraphException {
        try {
            this.vertices.remove(v);
        }
        catch (Exception ex) {
            throw new GraphException(ex);
        }
    }

    public void removeVertex(Vertex v) throws GraphException {
        Iterator conts = this.contracts.iterator();
        while (conts.hasNext()) {
            ((Contract)conts.next()).removeVertex(v);
        }
        this.removeVertexI(v);
    }

    private void addEdgeI(Edge e, Vertex start, Vertex end) throws GraphException {
        HashSet<Edge> edgeSet;
        this.edges.add(e);
        if (e instanceof WeightedEdge) {
            this.edgeWeights.put(e, new Double(((WeightedEdge)e).getWeight()));
        } else {
            this.edgeWeights.put(e, new Double(1.0));
        }
        this.edgeSource.put(e, start);
        this.edgeTarget.put(e, end);
        if (!this.outbound.containsKey(start)) {
            edgeSet = new HashSet<Edge>();
            edgeSet.add(e);
            this.outbound.put(start, edgeSet);
        } else {
            ((Set)this.outbound.get(start)).add(e);
        }
        if (!this.inbound.containsKey(end)) {
            edgeSet = new HashSet();
            edgeSet.add(e);
            this.inbound.put(end, edgeSet);
        } else {
            ((Set)this.inbound.get(end)).add(e);
        }
    }

    public void addEdge(Edge e, Vertex start, Vertex end) throws GraphException {
        Iterator conts = this.contracts.iterator();
        while (conts.hasNext()) {
            Contract cont = (Contract)conts.next();
            cont.addEdge(e, start, end);
        }
        this.addEdgeI(e, start, end);
    }

    private void removeEdgeI(Edge e) throws GraphException {
        try {
            Set edgeSet = null;
            Vertex source = (Vertex)this.edgeSource.get(e);
            this.edgeSource.remove(e);
            edgeSet = (Set)this.outbound.get(source);
            edgeSet.remove(e);
            Vertex target = (Vertex)this.edgeTarget.get(e);
            this.edgeTarget.remove(e);
            edgeSet = (Set)this.inbound.get(target);
            edgeSet.remove(e);
            if (this.edgeWeights.containsKey(e)) {
                this.edgeWeights.remove(e);
            }
        }
        catch (Exception ex) {
            throw new GraphException(ex);
        }
    }

    public void removeEdge(Edge e) throws GraphException {
        Iterator conts = this.contracts.iterator();
        while (conts.hasNext()) {
            ((Contract)conts.next()).removeEdge(e);
        }
        this.removeEdgeI(e);
    }

    public double getWeight(Edge e) {
        if (this.edgeWeights.containsKey(e)) {
            return (Double)this.edgeWeights.get(e);
        }
        return 1.0;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

