/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.domain.jdepend;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jdepend.framework.JDepend;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.domain.basic.DirectedGraphImpl;
import org.apache.commons.graph.domain.jdepend.ClassVertex;
import org.apache.commons.graph.domain.jdepend.ImportEdge;
import org.apache.commons.graph.domain.jdepend.OwnershipEdge;
import org.apache.commons.graph.domain.jdepend.PackageVertex;

public class JDependGraph
extends DirectedGraphImpl
implements DirectedGraph {
    private JDepend jdep = new JDepend();
    private Map pkgMap = new HashMap();
    private Map clazzMap = new HashMap();

    public void addDirectory(String directory) throws IOException {
        this.jdep.addDirectory(directory);
    }

    private PackageVertex findPackageVertex(JavaPackage pkg) {
        if (this.pkgMap.containsKey(pkg.getName())) {
            return (PackageVertex)this.pkgMap.get(pkg.getName());
        }
        PackageVertex RC = new PackageVertex(pkg);
        this.pkgMap.put(pkg.getName(), RC);
        this.addVertex(RC);
        return RC;
    }

    private ClassVertex findClassVertex(JavaClass clz) {
        if (this.clazzMap.containsKey(clz)) {
            return (ClassVertex)this.clazzMap.get(clz);
        }
        ClassVertex RC = new ClassVertex(clz);
        this.clazzMap.put(clz, RC);
        this.addVertex(RC);
        return RC;
    }

    public void analyze() {
        Iterator pkgs = this.jdep.analyze().iterator();
        while (pkgs.hasNext()) {
            JavaPackage pkg = (JavaPackage)pkgs.next();
            PackageVertex pv = this.findPackageVertex(pkg);
            Iterator clzs = pkg.getClasses().iterator();
            while (clzs.hasNext()) {
                JavaClass clz = (JavaClass)clzs.next();
                ClassVertex cv = this.findClassVertex(clz);
                OwnershipEdge oe = new OwnershipEdge(pkg, clz);
                this.addEdge(oe, pv, cv);
                this.setWeight(oe, 5.0);
                Iterator ipkgs = clz.getImportedPackages().iterator();
                while (ipkgs.hasNext()) {
                    JavaPackage ipkg = (JavaPackage)ipkgs.next();
                    PackageVertex ipv = this.findPackageVertex(ipkg);
                    ImportEdge ie = new ImportEdge(clz, pkg);
                    this.addEdge(ie, cv, ipv);
                    this.setWeight(ie, 200.0 * (double)ipkg.afferentCoupling() + 100.0);
                }
            }
        }
    }
}

