/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.domain.statemachine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.graph.MutableDirectedGraph;
import org.apache.commons.graph.contract.Contract;
import org.apache.commons.graph.decorator.DDirectedGraph;
import org.apache.commons.graph.domain.statemachine.State;
import org.apache.commons.graph.domain.statemachine.Transition;
import org.apache.commons.graph.exception.GraphException;
import org.apache.commons.graph.factory.GraphFactory;

public class StateMachine
extends DDirectedGraph {
    private Map states = new HashMap();
    private Map transes = new HashMap();
    private Set finalStates = new HashSet();
    private State startState = null;
    private MutableDirectedGraph graph = null;
    private String name;
    private GraphFactory factory = new GraphFactory();

    public StateMachine(String name) {
        this.name = name;
        Contract[] contracts = new Contract[]{};
        this.graph = this.factory.makeMutableDirectedGraph(contracts, false, null);
        this.setDirGraph(this.graph);
    }

    public String getName() {
        return this.name;
    }

    public void addState(State state) throws GraphException {
        this.states.put(state.getName(), state);
        this.graph.addVertex(state);
    }

    public void addState(String name) throws GraphException {
        State newState = new State(name);
        this.addState(new State(name));
    }

    public void setStartState(State state) {
        this.startState = state;
    }

    public void addFinalState(State state) {
        this.finalStates.add(state);
    }

    public void addTransition(String name, String source, String target) throws GraphException {
        this.addTransition(name, this.getState(source), this.getState(target));
    }

    public void addTransition(String name, State source, State target) throws GraphException {
        Transition trans = new Transition(name, source, target);
        this.addTransition(trans);
    }

    public void addTransition(Transition trans) throws GraphException {
        this.transes.put(trans.getName(), trans);
        this.graph.addEdge(trans, trans.getSource(), trans.getTarget());
    }

    public State getState(String name) {
        return (State)this.states.get(name);
    }

    public Transition getTransition(String name) {
        return (Transition)this.transes.get(name);
    }
}

