' Word2HTML.vbs
' $Id: word2html.vbs,v 1.5 2003/08/28 05:15:09 dion Exp $
Option Explicit

' Creates the output directories to the same depth as the inputFile specified
' param inBaseDir         The base directory for input files
' param inputFile         The file being processed
' param outBaseDir        The base directory for output files
Function CreateOutputDirectories(inBaseDir, inputFile, outBaseDir)
  Dim relativePath
  relativePath = Mid(inputFile, Len(inBaseDir)+1)
  
  ' ensure the path doesn't end with a \
  If Left(relativePath, 1) = "\" Then
      relativePath = Right(relativePath, Len(relativePath) - 1)
  End If
  
  ' ensure the input basedir doesn't end with a \
  If Right(inBaseDir, 1) = "\" Then
      baseDir = Left(inBaseDir, Len(inBaseDir) - 1)
  End If
  
  ' ensure the output basedir doesn't end with a \
  If Right(outBaseDir, 1) = "\" Then
      outBaseDir = Left(outBaseDir, Len(outBaseDir) - 1)
  End If
  
  Dim index, folder, paths, Files
  paths = Split(relativePath, "\")
  folder = outBaseDir
  Set Files = WScript.CreateObject("Scripting.FileSystemObject")
  For index = LBound(paths) to UBound(paths) -1
      folder = folder & "\" & paths(index)
      If Not Files.FolderExists(folder) Then
      	Files.CreateFolder(folder)
      End If
  Next 
  
  CreateOutputDirectories = folder
End Function

Function ExportAsHTML(inputFile, outputFile)
	Dim obj, HTMLFormat, wdDoNotSaveChanges
	Set obj = WScript.CreateObject("Word.Application")
	HTMLFormat = 8
	wdDoNotSaveChanges = 0

	obj.Visible = FALSE
	obj.Documents.Open inputFile,,True
	obj.ActiveDocument.SaveAs outputFile, HTMLFormat
	obj.Quit wdDoNotSaveChanges

End Function

' Main chunk of code
Dim basedir, FileSys, inputFile, outputDir, outputFile
On Error Resume Next

' work out the directory structure for the input file
Set FileSys = WScript.CreateObject("Scripting.FileSystemObject")

' Fully Qualified File name
inputFile=FileSys.GetAbsolutePathName(WScript.Arguments(0))
' Directory to place results in
outputDir=FileSys.GetAbsolutePathName(WScript.Arguments(1))
' base directory for the input file
basedir = FileSys.GetAbsolutePathName(WScript.Arguments(2))

outputFile = CreateOutputDirectories(basedir, inputFile, outputDir) & "\" & _
    FileSys.GetBaseName(inputFile) & ".html"
    
' check if output file exists and is newer than input file
' if it is, skip output
If FileSys.Exists(outputFile) Then
	Dim fileOutput, fileInput
	Set fileOutput = FileSys.GetFile(outputFile)
	Set fileInput = FileSys.GetFile(inputFile)
	If fileOutput.DateLastModified < fileInput.DateLastModified Then
		ExportAsHTML inputFile, outputFile
	End If
Else 
	ExportAsHTML inputFile, outputFile
End If