// SliderCtrl.h cXC_Rg[̃TuNX
#ifndef __WGC_SLIDERCTRL__
#define __WGC_SLIDERCTRL__

#include "Control.h"
#include <commctrl.h>


_WGC_BEGIN                              // namespace wgc {

class SliderCtrl : public Control
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit SliderCtrl(HWND hWnd = NULL);
	virtual ~SliderCtrl(void);

	// s̃TCY
	int GetLineSize(void) const;
	int SetLineSize(const int nSize);

	// y[WTCY
	int GetPageSize(void) const;
	int SetPageSize(const int nSize);

	// ŏl
	int GetRangeMin(void) const;
	void SetRangeMin(const int nMin, const BOOL bRedraw = FALSE);

	// ől
	int GetRangeMax(void) const;
	void SetRangeMax(const int nMax, const BOOL bRedraw = FALSE);

	// ͈
	void GetRange(      int &nMin,       int &rMax) const;
	void SetRange(const int  nMin, const int  nMax, BOOL bRedraw = FALSE);

	// `
	void GetChannelRect(LPRECT lprc) const;
	void GetThumbRect(LPRECT lprc) const;

	// ܂݂̈ʒu
	int GetPos(void) const;
	void SetPos(const int nPos);

	// ڐ}[N
	UINT GetNumTics(void) const;
	int  GetTic(const int nTic) const;
	BOOL SetTic(const int nTic);
	int  GetTicPos(const int nTic) const;
	void SetTicFreq(const int nFreq);

	// ofB
	HWND GetBuddy(const BOOL fLocation = TRUE) const;
	HWND SetBuddy(HWND hWndBuddy, const BOOL fLocation = TRUE);

	// 
	void ClearSel(const BOOL bRedraw = FALSE);
	void ClearTics(const BOOL bRedraw = FALSE);

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(SliderCtrl)
};

_WGC_END                                // }

#endif // __WGC_SLIDERCTRL__
