// ToolBarCtrl.h cc[o[̃TuNX
#ifndef __WGC_TOOLBAR__
#define __WGC_TOOLBAR__

#include "Control.h"
#include <vector>


#define TBREBARSTYLE        (WS_CHILD | WS_VISIBLE)
#define TBREBARSTYLE_CTL    (CCS_TOP | CCS_ADJUSTABLE | CCS_NORESIZE | CCS_NODIVIDER)
#define TBREBARSTYLE_TB     (TBSTYLE_FLAT | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT)


_WGC_BEGIN                              // namespace wgc {

class ToolBarCtrl : public Control
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit ToolBarCtrl(HWND hWnd = NULL);
	virtual ~ToolBarCtrl(void);

	BOOL Create(
		Window *parent,
		HIMAGELIST hImageList,
		HIMAGELIST hHotImageList,
		HIMAGELIST hDisabledImageList,
		HINSTANCE hResource,
		const int arCommand[],
		const int nCommandCount,
		const DWORD dwStyle        = WS_CHILD | WS_VISIBLE,
		const DWORD dwCtlStyle     = CCS_TOP | CCS_ADJUSTABLE,
		const DWORD dwToolBarStyle = TBSTYLE_FLAT | TBSTYLE_TOOLTIPS | TBSTYLE_ALTDRAG,
		const DWORD dwExStyle      = 0,
		const UINT  nID            = IDW_STD_TOOLBAR);

	// Agr[g
	void GetButtonSize(SIZE &size) const;
	BOOL GetButton(const UINT iButton, TBBUTTON &tbButton) const;
	UINT GetButtonCount(void) const;
	BOOL GetMaxSize(SIZE &size) const;

	// Iy[V
	void Customize(void);
	void ButtonStructSize(void);
	BOOL AddButtons(LPTBBUTTON lpButtons, const UINT nNumButtons);
	BOOL DeleteButton(const UINT iButton);

	// C[WXg
	HIMAGELIST SetImageList        (HIMAGELIST hImageList);
	HIMAGELIST SetHotImageList     (HIMAGELIST hHotImageList);
	HIMAGELIST SetDisabledImageList(HIMAGELIST hDisabledImageList);

	void SaveRestore(const BOOL bSave, TBSAVEPARAMS &tbs);

	// ʒmbZ[W̏
	BOOL HandleNotifyMessage(LPNMHDR lpNmHeader, BOOL &bResult);

protected:
	typedef struct _button_info_t
	{
		TBBUTTON  button;
		tstring_t str;
	} button_info_t;
	std::vector<button_info_t> m_button_array;

	virtual void OnNotify_BeginAdjust(LPTBNOTIFY lpNotify);
	virtual void OnNotify_EndAdjust  (LPTBNOTIFY lpNotify);

	virtual BOOL OnNotify_QueryInsert(LPTBNOTIFY lpNotify);
	virtual BOOL OnNotify_QueryDelete(LPTBNOTIFY lpNotify);

	virtual void OnNotify_BeginDrag(LPTBNOTIFY lpNotify);
	virtual void OnNotify_EndDrag  (LPTBNOTIFY lpNotify);

	virtual BOOL OnNotify_GetButtonInfo(LPTBNOTIFY lpNotify) const;

	virtual void OnNotify_ToolbarChange(LPTBNOTIFY lpNotify);
	virtual void OnNotify_Reset   (LPTBNOTIFY lpNotify);
	virtual void OnNotify_CustHelp(LPTBNOTIFY lpNotify);

	virtual BOOL OnNotify_Save   (LPNMTBSAVE    lpNmTbSave   );
	virtual BOOL OnNotify_Restore(LPNMTBRESTORE lpNmTbRestore) const;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(ToolBarCtrl)
};

_WGC_END                                // }

#endif // __WGC_TOOLBAR__
