/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.Serializable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.StringUtils;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    private String[] codes;
    private Object[] arguments;
    private String defaultMessage;

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments) {
        this(codes, arguments, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments, String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    protected DefaultMessageSourceResolvable() {
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected void setCodes(String[] codes) {
        this.codes = (String[])codes.clone();
    }

    protected void setArguments(Object[] arguments) {
        this.arguments = (Object[])arguments.clone();
    }

    protected void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    protected String resolvableToString() {
        StringBuffer msgBuff = new StringBuffer();
        msgBuff.append("codes=[" + StringUtils.arrayToDelimitedString(this.getCodes(), ",") + "]; arguments=[");
        if (this.arguments == null) {
            msgBuff.append("null");
        } else {
            for (int i = 0; i < this.getArguments().length; ++i) {
                msgBuff.append("(" + this.getArguments()[i].getClass().getName() + ")[" + this.getArguments()[i] + "]");
                if (i >= this.getArguments().length - 1) continue;
                msgBuff.append(", ");
            }
        }
        msgBuff.append("]; defaultMessage=[" + this.getDefaultMessage() + "]");
        return msgBuff.toString();
    }

    public String toString() {
        return this.resolvableToString();
    }
}

