/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionObject;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DataSourceTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private DataSource dataSource;

    public DataSourceTransactionManager() {
    }

    public DataSourceTransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
        this.afterPropertiesSet();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
    }

    protected Object doGetTransaction() {
        if (TransactionSynchronizationManager.hasResource(this.dataSource)) {
            ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.dataSource);
            return new DataSourceTransactionObject(holder);
        }
        return new DataSourceTransactionObject();
    }

    protected boolean isExistingTransaction(Object transaction) {
        return TransactionSynchronizationManager.hasResource(this.dataSource);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        Connection con;
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (txObject.getConnectionHolder() == null) {
            if (debugEnabled) {
                this.logger.debug((Object)"Opening new connection for JDBC transaction");
            }
            con = DataSourceUtils.getConnection(this.dataSource, false);
            txObject.setConnectionHolder(new ConnectionHolder(con));
        }
        con = txObject.getConnectionHolder().getConnection();
        try {
            if (definition.isReadOnly()) {
                if (debugEnabled) {
                    this.logger.debug((Object)("Setting JDBC connection [" + con + "] read-only"));
                }
                try {
                    con.setReadOnly(true);
                }
                catch (Exception ex) {
                    this.logger.warn((Object)"Could not set JDBC connection read-only", (Throwable)ex);
                }
            }
            if (definition.getIsolationLevel() != -1) {
                if (debugEnabled) {
                    this.logger.debug((Object)("Changing isolation level of JDBC connection [" + con + "] to " + definition.getIsolationLevel()));
                }
                txObject.setPreviousIsolationLevel(new Integer(con.getTransactionIsolation()));
                con.setTransactionIsolation(definition.getIsolationLevel());
            }
            if (con.getAutoCommit()) {
                txObject.setMustRestoreAutoCommit(true);
                if (debugEnabled) {
                    this.logger.debug((Object)("Switching JDBC connection [" + con + "] to manual commit"));
                }
                con.setAutoCommit(false);
            }
            if (definition.getTimeout() != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            TransactionSynchronizationManager.bindResource(this.dataSource, txObject.getConnectionHolder());
        }
        catch (SQLException ex) {
            throw new CannotCreateTransactionException("Could not configure connection", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.dataSource);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        ConnectionHolder conHolder = (ConnectionHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.dataSource, conHolder);
    }

    protected boolean isRollbackOnly(Object transaction) throws TransactionException {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        return txObject.getConnectionHolder().isRollbackOnly();
    }

    protected void doCommit(DefaultTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JDBC transaction [" + txObject.getConnectionHolder().getConnection() + "]"));
        }
        try {
            txObject.getConnectionHolder().getConnection().commit();
        }
        catch (SQLException ex) {
            throw new TransactionSystemException("Could not commit", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JDBC transaction [" + txObject.getConnectionHolder().getConnection() + "]"));
        }
        try {
            txObject.getConnectionHolder().getConnection().rollback();
        }
        catch (SQLException ex) {
            throw new TransactionSystemException("Could not rollback", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JDBC transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
        }
        txObject.getConnectionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.dataSource);
        Connection con = txObject.getConnectionHolder().getConnection();
        try {
            if (txObject.getMustRestoreAutoCommit()) {
                con.setAutoCommit(true);
            }
            if (txObject.getPreviousIsolationLevel() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Resetting isolation level of connection [" + con + "] to " + txObject.getPreviousIsolationLevel()));
                }
                con.setTransactionIsolation(txObject.getPreviousIsolationLevel());
            }
            if (con.isReadOnly()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Resetting read-only flag of connection [" + con + "]"));
                }
                con.setReadOnly(false);
            }
        }
        catch (Exception ex) {
            this.logger.info((Object)"Could not reset JDBC connection", (Throwable)ex);
        }
        try {
            DataSourceUtils.closeConnectionIfNecessary(con, this.dataSource);
        }
        catch (CleanupFailureDataAccessException ex) {
            this.logger.error((Object)"Could not close connection after transaction", (Throwable)((Object)ex));
        }
    }
}

