/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.io.Serializable;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.swarmcache.ObjectCache;

public class SwarmCache
implements Cache {
    private ObjectCache cache;

    public SwarmCache(ObjectCache cache) {
        this.cache = cache;
    }

    public Object get(Object key) throws CacheException {
        if (key instanceof Serializable) {
            return this.cache.get((Serializable)key);
        }
        throw new CacheException("Keys must implement Serializable");
    }

    public void put(Object key, Object value) throws CacheException {
        if (!(key instanceof Serializable)) {
            throw new CacheException("Keys must implement Serializable");
        }
        this.cache.put((Serializable)key, value);
    }

    public void remove(Object key) throws CacheException {
        if (!(key instanceof Serializable)) {
            throw new CacheException("Keys must implement Serializable");
        }
        this.cache.clear((Serializable)key);
    }

    public void clear() throws CacheException {
        this.cache.clearAll();
    }

    public void destroy() throws CacheException {
        this.cache.clearAll();
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("SwarmCache does not support locking (use nonstrict-read-write)");
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("SwarmCache does not support locking (use nonstrict-read-write)");
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }
}

