/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.odmg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.Bag;
import net.sf.hibernate.collection.List;
import net.sf.hibernate.collection.Map;
import net.sf.hibernate.collection.Set;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.odmg.Database;
import net.sf.hibernate.odmg.OQLQuery;
import net.sf.hibernate.odmg.Transaction;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;

public class Implementation
implements org.odmg.Implementation {
    private Database database;
    private final ThreadLocal threadDatabase = new ThreadLocal();
    private static final Implementation INSTANCE = new Implementation();

    public static Implementation getInstance() {
        return INSTANCE;
    }

    public org.odmg.Transaction newTransaction() {
        try {
            return new Transaction(this.currentDatabase());
        }
        catch (ODMGException ode) {
            throw new ODMGRuntimeException(ode.getMessage());
        }
    }

    public Database currentDatabase() {
        Database db = (Database)this.threadDatabase.get();
        if (db != null) {
            return db;
        }
        return this.database;
    }

    public org.odmg.Transaction currentTransaction() {
        return this.currentDatabase().currentTransaction();
    }

    public synchronized org.odmg.Database newDatabase() {
        Database db = new Database();
        if (this.database == null) {
            this.database = db;
        }
        this.threadDatabase.set(db);
        return db;
    }

    public org.odmg.OQLQuery newOQLQuery() {
        return new OQLQuery(this.currentDatabase());
    }

    public DList newDList() {
        return new List((SessionImplementor)this.currentDatabase().getSession(), new ArrayList());
    }

    public DBag newDBag() {
        return new Bag((SessionImplementor)this.currentDatabase().getSession(), new ArrayList());
    }

    public DSet newDSet() {
        return new Set((SessionImplementor)this.currentDatabase().getSession(), new HashSet());
    }

    public DArray newDArray() {
        return new List((SessionImplementor)this.currentDatabase().getSession(), new ArrayList());
    }

    public DMap newDMap() {
        return new Map((SessionImplementor)this.currentDatabase().getSession(), new HashMap());
    }

    public String getObjectId(Object obj) {
        try {
            return this.database.getSession().getIdentifier(obj).toString();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public org.odmg.Database getDatabase(Object obj) {
        return this.currentDatabase();
    }
}

