/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.cache.memory;

import com.ibatis.db.sqlmap.cache.CacheController;
import com.ibatis.db.sqlmap.cache.CacheModel;
import com.ibatis.db.sqlmap.cache.memory.MemoryCacheLevel;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MemoryCacheController
implements CacheController {
    private MemoryCacheLevel cacheLevel = MemoryCacheLevel.WEAK;
    private Map cache = new HashMap();

    public void configure(Properties properties) {
        String string = properties.getProperty("reference-type");
        if (string != null) {
            this.cacheLevel = MemoryCacheLevel.getByReferenceType(string);
        }
    }

    public void putObject(CacheModel cacheModel, Object object, Object object2) {
        MemoryCacheController memoryCacheController = this;
        synchronized (memoryCacheController) {
            Object object3 = null;
            if (this.cacheLevel.equals(MemoryCacheLevel.WEAK)) {
                object3 = new WeakReference<Object>(object2);
            } else if (this.cacheLevel.equals(MemoryCacheLevel.SOFT)) {
                object3 = new SoftReference<Object>(object2);
            } else if (this.cacheLevel.equals(MemoryCacheLevel.STRONG)) {
                object3 = new StrongReference(object2);
            }
            this.cache.put(object, object3);
        }
    }

    public Object getObject(CacheModel cacheModel, Object object) {
        MemoryCacheController memoryCacheController = this;
        synchronized (memoryCacheController) {
            Object object2 = null;
            Object v = this.cache.get(object);
            if (v != null) {
                if (v instanceof StrongReference) {
                    object2 = ((StrongReference)v).get();
                } else if (v instanceof SoftReference) {
                    object2 = ((SoftReference)v).get();
                } else if (v instanceof WeakReference) {
                    object2 = ((WeakReference)v).get();
                }
            }
            Object object3 = object2;
            return object3;
        }
    }

    public void flush(CacheModel cacheModel) {
        MemoryCacheController memoryCacheController = this;
        synchronized (memoryCacheController) {
            this.cache.clear();
        }
    }

    private static class StrongReference {
        private Object object;

        public StrongReference(Object object) {
            this.object = object;
        }

        public Object get() {
            return this.object;
        }
    }
}

