/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.RegisterClassEvent;
import javax.jdo.spi.RegisterClassListener;
import javax.jdo.spi.StateManager;

public class JDOImplHelper {
    private static Map registeredClasses = Collections.synchronizedMap(new HashMap());
    private static Set authorizedStateManagerClasses = new HashSet();
    private static List listeners = new ArrayList();
    private static JDOImplHelper jdoImplHelper = new JDOImplHelper();
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");

    private JDOImplHelper() {
    }

    public static JDOImplHelper getInstance() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.GET_METADATA);
        }
        return jdoImplHelper;
    }

    public String[] getFieldNames(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getFieldNames();
    }

    public Class[] getFieldTypes(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getFieldTypes();
    }

    public byte[] getFieldFlags(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getFieldFlags();
    }

    public Class getPersistenceCapableSuperclass(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getPersistenceCapableSuperclass();
    }

    public PersistenceCapable newInstance(Class clazz, StateManager stateManager) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewInstance(stateManager);
    }

    public PersistenceCapable newInstance(Class clazz, StateManager stateManager, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewInstance(stateManager, object);
    }

    public Object newObjectIdInstance(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewObjectIdInstance();
    }

    public Object newObjectIdInstance(Class clazz, String string) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewObjectIdInstance(string);
    }

    public void copyKeyFieldsToObjectId(Class clazz, PersistenceCapable.ObjectIdFieldSupplier objectIdFieldSupplier, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        if (persistenceCapable == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", clazz.getName()));
        }
        persistenceCapable.jdoCopyKeyFieldsToObjectId(objectIdFieldSupplier, object);
    }

    public void copyKeyFieldsFromObjectId(Class clazz, PersistenceCapable.ObjectIdFieldConsumer objectIdFieldConsumer, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        if (persistenceCapable == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", clazz.getName()));
        }
        persistenceCapable.jdoCopyKeyFieldsFromObjectId(objectIdFieldConsumer, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClass(Class clazz, String[] stringArray, Class[] classArray, byte[] byArray, Class clazz2, PersistenceCapable persistenceCapable) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Meta meta = new Meta(stringArray, classArray, byArray, clazz2, persistenceCapable);
        registeredClasses.put(clazz, meta);
        List list = listeners;
        synchronized (list) {
            if (!listeners.isEmpty()) {
                RegisterClassEvent registerClassEvent = new RegisterClassEvent(jdoImplHelper, clazz, stringArray, classArray, byArray, clazz2);
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    RegisterClassListener registerClassListener = (RegisterClassListener)iterator.next();
                    if (registerClassListener == null) continue;
                    registerClassListener.registerClass(registerClassEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegisterClassListener(RegisterClassListener registerClassListener) {
        HashSet hashSet = null;
        List list = listeners;
        synchronized (list) {
            listeners.add(registerClassListener);
            hashSet = new HashSet(registeredClasses.keySet());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Meta meta = JDOImplHelper.getMeta(clazz);
            RegisterClassEvent registerClassEvent = new RegisterClassEvent(this, clazz, meta.getFieldNames(), meta.getFieldTypes(), meta.getFieldFlags(), meta.getPersistenceCapableSuperclass());
            registerClassListener.registerClass(registerClassEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegisterClassListener(RegisterClassListener registerClassListener) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(registerClassListener);
        }
    }

    public Collection getRegisteredClasses() {
        return Collections.unmodifiableCollection(registeredClasses.keySet());
    }

    private static Meta getMeta(Class clazz) {
        Meta meta = (Meta)registeredClasses.get(clazz);
        if (meta == null) {
            throw new JDOFatalUserException(msg.msg("ERR_NoMetadata", clazz.getName()));
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClass(Class clazz) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.SET_STATE_MANAGER);
        }
        Set set = authorizedStateManagerClasses;
        synchronized (set) {
            authorizedStateManagerClasses.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClasses(Collection collection) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.SET_STATE_MANAGER);
            Set set = authorizedStateManagerClasses;
            synchronized (set) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Class)) {
                        throw new ClassCastException(msg.msg("ERR_StateManagerClassCast", e.getClass().getName()));
                    }
                    JDOImplHelper.registerAuthorizedStateManagerClass((Class)iterator.next());
                }
            }
        }
    }

    public static void checkAuthorizedStateManager(StateManager stateManager) {
        JDOImplHelper.checkAuthorizedStateManagerClass(stateManager.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAuthorizedStateManagerClass(Class clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        Set set = authorizedStateManagerClasses;
        synchronized (set) {
            if (authorizedStateManagerClasses.contains(clazz)) {
                return;
            }
        }
        securityManager.checkPermission(JDOPermission.SET_STATE_MANAGER);
    }

    static class Meta {
        String[] fieldNames;
        Class[] fieldTypes;
        byte[] fieldFlags;
        Class persistenceCapableSuperclass;
        PersistenceCapable pc;

        Meta(String[] stringArray, Class[] classArray, byte[] byArray, Class clazz, PersistenceCapable persistenceCapable) {
            this.fieldNames = stringArray;
            this.fieldTypes = classArray;
            this.fieldFlags = byArray;
            this.persistenceCapableSuperclass = clazz;
            this.pc = persistenceCapable;
        }

        String[] getFieldNames() {
            return this.fieldNames;
        }

        Class[] getFieldTypes() {
            return this.fieldTypes;
        }

        byte[] getFieldFlags() {
            return this.fieldFlags;
        }

        Class getPersistenceCapableSuperclass() {
            return this.persistenceCapableSuperclass;
        }

        PersistenceCapable getPC() {
            return this.pc;
        }

        public String toString() {
            return "Meta-" + this.pc.getClass().getName();
        }
    }
}

