/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CacheModel
implements ExecuteListener {
    private Object STATS_LOCK = new Object();
    private int requests = 0;
    private int hits = 0;
    private static final long NO_FLUSH_INTERVAL = -99999L;
    private String id;
    private boolean readOnly;
    private long lastFlush = System.currentTimeMillis();
    private long flushInterval = -99999L;
    private long flushIntervalSeconds = -99999L;
    private Set flushTriggerStatements = new HashSet();
    private CacheController controller;
    private String resource;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setControllerClassName(String implementation) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = Resources.classForName((String)implementation);
        this.controller = (CacheController)Resources.instantiate((Class)clazz);
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public long getFlushIntervalSeconds() {
        return this.flushIntervalSeconds;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        this.flushIntervalSeconds = flushInterval / 1000L;
    }

    public void addFlushTriggerStatement(String statementName) {
        this.flushTriggerStatements.add(statementName);
    }

    public Iterator getFlushTriggerStatementNames() {
        return this.flushTriggerStatements.iterator();
    }

    public void onExecuteStatement(MappedStatement statement) {
        this.flush();
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public void configure(Properties props) {
        this.controller.configure(props);
    }

    public void flush() {
        this.lastFlush = System.currentTimeMillis();
        this.controller.flush(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(CacheKey key) {
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            if (this.flushInterval != -99999L && System.currentTimeMillis() - this.lastFlush > this.flushInterval) {
                this.flush();
            }
        }
        Object value = this.controller.getObject(this, key);
        Object object = this.STATS_LOCK;
        synchronized (object) {
            ++this.requests;
            if (value != null) {
                ++this.hits;
            }
        }
        return value;
    }

    public void putObject(CacheKey key, Object value) {
        this.controller.putObject(this, key, value);
    }
}

