/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.oscache;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Properties;

public class OSCacheController
implements CacheController {
    private static final GeneralCacheAdministrator CACHE = new GeneralCacheAdministrator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(CacheModel cacheModel) {
        CacheModel cacheModel2 = cacheModel;
        synchronized (cacheModel2) {
            CACHE.flushGroup(cacheModel.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(CacheModel cacheModel, Object key) {
        String keyString = key.toString();
        try {
            CacheModel cacheModel2 = cacheModel;
            synchronized (cacheModel2) {
                int refreshPeriod = (int)cacheModel.getFlushIntervalSeconds();
                return CACHE.getFromCache(keyString, refreshPeriod);
            }
        }
        catch (NeedsRefreshException e) {
            CACHE.cancelUpdate(keyString);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object removeObject(CacheModel cacheModel, Object key) {
        String keyString = key.toString();
        try {
            CacheModel cacheModel2 = cacheModel;
            synchronized (cacheModel2) {
                int refreshPeriod = (int)cacheModel.getFlushIntervalSeconds();
                Object value = CACHE.getFromCache(keyString, refreshPeriod);
                if (value != null) {
                    CACHE.flushEntry(keyString);
                }
                return value;
            }
        }
        catch (NeedsRefreshException e) {
            try {
                CACHE.flushEntry(keyString);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                CACHE.cancelUpdate(keyString);
                return null;
            }
            CACHE.cancelUpdate(keyString);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(CacheModel cacheModel, Object key, Object object) {
        String keyString = key.toString();
        CacheModel cacheModel2 = cacheModel;
        synchronized (cacheModel2) {
            CACHE.putInCache(keyString, object, new String[]{cacheModel.getId()});
        }
    }

    public void configure(Properties props) {
    }
}

