/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.beans.BeanProbe;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.jdbc.logging.ConnectionLogProxy;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.common.util.ThrottledPool;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.PaginatedDataList;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlMapExecutorDelegate {
    public static final int DEFAULT_MAX_REQUESTS = 512;
    public static final int DEFAULT_MAX_SESSIONS = 128;
    public static final int DEFAULT_MAX_TRANSACTIONS = 32;
    private static final Log log = LogFactory.getLog((Class)(class$com$ibatis$sqlmap$engine$impl$SqlMapExecutorDelegate == null ? (class$com$ibatis$sqlmap$engine$impl$SqlMapExecutorDelegate = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate")) : class$com$ibatis$sqlmap$engine$impl$SqlMapExecutorDelegate));
    private boolean lazyLoadingEnabled;
    private boolean cacheModelsEnabled;
    private boolean enhancementEnabled;
    private int maxRequests = 512;
    private int maxSessions = 128;
    private int maxTransactions = 32;
    private TransactionManager txManager;
    private HashMap mappedStatements = new HashMap();
    private ThrottledPool requestPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$RequestScope == null ? (class$com$ibatis$sqlmap$engine$scope$RequestScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.RequestScope")) : class$com$ibatis$sqlmap$engine$scope$RequestScope, 512);
    private ThrottledPool sessionPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$SessionScope == null ? (class$com$ibatis$sqlmap$engine$scope$SessionScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.SessionScope")) : class$com$ibatis$sqlmap$engine$scope$SessionScope, 128);
    private SqlExecutor sqlExecutor = new SqlExecutor();
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$impl$SqlMapExecutorDelegate;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$scope$RequestScope;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$scope$SessionScope;

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    public boolean isCacheModelsEnabled() {
        return this.cacheModelsEnabled;
    }

    public void setCacheModelsEnabled(boolean cacheModelsEnabled) {
        this.cacheModelsEnabled = cacheModelsEnabled;
    }

    public boolean isEnhancementEnabled() {
        return this.enhancementEnabled;
    }

    public void setEnhancementEnabled(boolean enhancementEnabled) {
        this.enhancementEnabled = enhancementEnabled;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
        this.requestPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$RequestScope == null ? (class$com$ibatis$sqlmap$engine$scope$RequestScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.RequestScope")) : class$com$ibatis$sqlmap$engine$scope$RequestScope, maxRequests);
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
        this.sessionPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$SessionScope == null ? (class$com$ibatis$sqlmap$engine$scope$SessionScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.SessionScope")) : class$com$ibatis$sqlmap$engine$scope$SessionScope, maxSessions);
    }

    public int getMaxTransactions() {
        return this.maxTransactions;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public void addMappedStatement(MappedStatement ms) {
        ms.setBaseCacheKey(this.hashCode());
        this.mappedStatements.put(ms.getId(), ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insert(SessionScope session, String id, Object param) throws SQLException {
        Object generatedKey = null;
        MappedStatement ms = this.getMappedStatement(id);
        Connection conn = this.getConnection(session);
        boolean autoStart = conn == null;
        try {
            conn = this.autoStartTransaction(session, autoStart, conn);
            SelectKeyStatement selectKeyStatement = null;
            if (ms instanceof InsertStatement) {
                selectKeyStatement = ((InsertStatement)ms).getSelectKeyStatement();
            }
            if (selectKeyStatement != null && !selectKeyStatement.isAfter()) {
                generatedKey = this.executeSelectKey(session, conn, ms, param);
            }
            RequestScope request = this.popRequest(session, ms);
            try {
                ms.executeUpdate(request, conn, param);
                Object var11_10 = null;
                this.pushRequest(request);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.pushRequest(request);
                throw throwable;
            }
            if (selectKeyStatement != null && selectKeyStatement.isAfter()) {
                generatedKey = this.executeSelectKey(session, conn, ms, param);
            }
            this.autoCommitTransaction(session, autoStart);
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.autoStopTransaction(session, autoStart);
            throw throwable;
        }
        this.autoStopTransaction(session, autoStart);
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSelectKey(SessionScope session, Connection conn, MappedStatement ms, Object param) throws SQLException {
        Object generatedKey = null;
        InsertStatement insert = (InsertStatement)ms;
        SelectKeyStatement selectKeyStatement = insert.getSelectKeyStatement();
        if (selectKeyStatement != null) {
            RequestScope request = this.popRequest(session, selectKeyStatement);
            try {
                generatedKey = selectKeyStatement.executeQueryForObject(request, conn, param, null);
                String keyProp = selectKeyStatement.getKeyProperty();
                if (keyProp != null) {
                    BeanProbe.setObject((Object)param, (String)keyProp, (Object)generatedKey);
                }
                Object var11_10 = null;
                this.pushRequest(request);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.pushRequest(request);
                throw throwable;
            }
        }
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(SessionScope session, String id, Object param) throws SQLException {
        int rows = 0;
        MappedStatement ms = this.getMappedStatement(id);
        Connection conn = this.getConnection(session);
        boolean autoStart = conn == null;
        try {
            conn = this.autoStartTransaction(session, autoStart, conn);
            RequestScope request = this.popRequest(session, ms);
            try {
                rows = ms.executeUpdate(request, conn, param);
                Object var10_9 = null;
                this.pushRequest(request);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.pushRequest(request);
                throw throwable;
            }
            this.autoCommitTransaction(session, autoStart);
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.autoStopTransaction(session, autoStart);
            throw throwable;
        }
        this.autoStopTransaction(session, autoStart);
        return rows;
    }

    public int delete(SessionScope session, String id, Object param) throws SQLException {
        return this.update(session, id, param);
    }

    public Object queryForObject(SessionScope session, String id, Object paramObject) throws SQLException {
        return this.queryForObject(session, id, paramObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object queryForObject(SessionScope session, String id, Object paramObject, Object resultObject) throws SQLException {
        Object object = null;
        MappedStatement ms = this.getMappedStatement(id);
        Connection conn = this.getConnection(session);
        boolean autoStart = conn == null;
        try {
            conn = this.autoStartTransaction(session, autoStart, conn);
            RequestScope request = this.popRequest(session, ms);
            try {
                object = ms.executeQueryForObject(request, conn, paramObject, resultObject);
                Object var11_10 = null;
                this.pushRequest(request);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.pushRequest(request);
                throw throwable;
            }
            this.autoCommitTransaction(session, autoStart);
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.autoStopTransaction(session, autoStart);
            throw throwable;
        }
        this.autoStopTransaction(session, autoStart);
        return object;
    }

    public List queryForList(SessionScope session, String id, Object paramObject) throws SQLException {
        return this.queryForList(session, id, paramObject, 0, -999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryForList(SessionScope session, String id, Object paramObject, int skip, int max) throws SQLException {
        List list = null;
        MappedStatement ms = this.getMappedStatement(id);
        Connection conn = this.getConnection(session);
        boolean autoStart = conn == null;
        try {
            conn = this.autoStartTransaction(session, autoStart, conn);
            RequestScope request = this.popRequest(session, ms);
            try {
                list = ms.executeQueryForList(request, conn, paramObject, skip, max);
                Object var12_11 = null;
                this.pushRequest(request);
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.pushRequest(request);
                throw throwable;
            }
            this.autoCommitTransaction(session, autoStart);
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.autoStopTransaction(session, autoStart);
            throw throwable;
        }
        this.autoStopTransaction(session, autoStart);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryForList(SessionScope session, String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        List list = null;
        MappedStatement ms = this.getMappedStatement(id);
        Connection conn = this.getConnection(session);
        boolean autoStart = conn == null;
        try {
            conn = this.autoStartTransaction(session, autoStart, conn);
            RequestScope request = this.popRequest(session, ms);
            try {
                list = ms.executeQueryForList(request, conn, paramObject, rowHandler);
                Object var11_10 = null;
                this.pushRequest(request);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.pushRequest(request);
                throw throwable;
            }
            this.autoCommitTransaction(session, autoStart);
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.autoStopTransaction(session, autoStart);
            throw throwable;
        }
        this.autoStopTransaction(session, autoStart);
        return list;
    }

    public PaginatedList queryForPaginatedList(SessionScope session, String id, Object paramObject, int pageSize) throws SQLException {
        return new PaginatedDataList(session.getSqlMapExecutor(), id, paramObject, pageSize);
    }

    public Map queryForMap(SessionScope session, String id, Object paramObject, String keyProp) throws SQLException {
        return this.queryForMap(session, id, paramObject, keyProp, null);
    }

    public Map queryForMap(SessionScope session, String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List list = this.queryForList(session, id, paramObject);
        int i = 0;
        int n = list.size();
        while (i < n) {
            Object object = list.get(i);
            Object key = BeanProbe.getObject(object, (String)keyProp);
            Object value = null;
            value = valueProp == null ? (Object)object : BeanProbe.getObject(object, (String)valueProp);
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public void startTransaction(SessionScope session) throws SQLException {
        try {
            this.txManager.begin(session);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    public void commitTransaction(SessionScope session) throws SQLException {
        try {
            if (session.isInBatch()) {
                this.executeBatch(session);
            }
            this.sqlExecutor.cleanup(session);
            this.txManager.commit(session);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not commit transaction.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(SessionScope session) throws SQLException {
        try {
            try {
                this.sqlExecutor.cleanup(session);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.txManager.end(session);
                throw throwable;
            }
            this.txManager.end(session);
            {
            }
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error while ending transaction.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    public void startBatch(SessionScope session) throws SQLException {
        session.setInBatch(true);
    }

    public int executeBatch(SessionScope session) throws SQLException {
        session.setInBatch(false);
        return this.sqlExecutor.executeBatch(session);
    }

    public Connection getUserConnection(SessionScope session) {
        return session.getUserConnection();
    }

    public void setUserConnection(SessionScope session, Connection userConnection) {
        session.setUserConnection(userConnection);
    }

    public DataSource getDataSource() {
        return this.txManager.getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        MappedStatement ms = (MappedStatement)this.mappedStatements.get(id);
        if (ms == null) {
            throw new SqlMapException("There is no statement named " + id + " in this SqlMap.");
        }
        return ms;
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    private Connection getConnection(SessionScope session) throws SQLException {
        Connection connection = session.getUserConnection();
        if (connection == null) {
            try {
                Transaction trans = session.getTransaction();
                if (trans != null) {
                    connection = trans.getConnection();
                }
            }
            catch (TransactionException e) {
                throw new NestedSQLException("Could not get connection.  Cause: " + (Object)((Object)e), (Throwable)((Object)e));
            }
        }
        return connection;
    }

    private void autoStopTransaction(SessionScope session, boolean autoStart) throws SQLException {
        if (autoStart) {
            session.getSqlMapTxMgr().endTransaction();
        }
    }

    private void autoCommitTransaction(SessionScope session, boolean autoStart) throws SQLException {
        if (autoStart) {
            session.getSqlMapTxMgr().commitTransaction();
        }
    }

    private Connection autoStartTransaction(SessionScope session, boolean autoStart, Connection conn) throws SQLException {
        Connection connection = conn;
        if (autoStart) {
            session.getSqlMapTxMgr().startTransaction();
            connection = this.getConnection(session);
        }
        if (connection != null && log.isDebugEnabled()) {
            connection = ConnectionLogProxy.newInstance((Connection)connection);
        }
        return connection;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        CacheKey key = new CacheKey();
        if (this.txManager != null) {
            key.update(this.txManager);
            if (this.txManager.getDataSource() != null) {
                key.update(this.txManager.getDataSource());
            }
        }
        key.update(System.identityHashCode(this));
        return key.hashCode();
    }

    protected RequestScope popRequest(SessionScope session, MappedStatement mappedStatement) {
        RequestScope request = (RequestScope)this.requestPool.pop();
        request.setSession(session);
        mappedStatement.initRequest(request);
        return request;
    }

    protected void pushRequest(RequestScope request) {
        request.reset();
        this.requestPool.push((Object)request);
    }

    protected SessionScope popSession() {
        return (SessionScope)this.sessionPool.pop();
    }

    protected void pushSession(SessionScope session) {
        session.reset();
        this.sessionPool.push((Object)session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

