/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class CachingStatement
implements MappedStatement {
    private MappedStatement statement;
    private CacheModel cacheModel;

    public CachingStatement(MappedStatement statement, CacheModel cacheModel) {
        this.statement = statement;
        this.cacheModel = cacheModel;
    }

    public String getId() {
        return this.statement.getId();
    }

    public ParameterMap getParameterMap() {
        return this.statement.getParameterMap();
    }

    public ResultMap getResultMap() {
        return this.statement.getResultMap();
    }

    public int executeUpdate(RequestScope request, Connection conn, Object parameterObject) throws SQLException {
        int n = this.statement.executeUpdate(request, conn, parameterObject);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeQueryForObject(RequestScope request, Connection conn, Object parameterObject, Object resultObject) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(request, parameterObject);
        cacheKey.update("executeQueryForObject");
        Object object = this.cacheModel.getObject(cacheKey);
        if (object == null) {
            CacheModel cacheModel = this.cacheModel;
            synchronized (cacheModel) {
                object = this.statement.executeQueryForObject(request, conn, parameterObject, resultObject);
                this.cacheModel.putObject(cacheKey, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeQueryForList(RequestScope request, Connection conn, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(request, parameterObject);
        cacheKey.update("executeQueryForList");
        List list = (List)this.cacheModel.getObject(cacheKey);
        if (list == null) {
            CacheModel cacheModel = this.cacheModel;
            synchronized (cacheModel) {
                list = this.statement.executeQueryForList(request, conn, parameterObject, skipResults, maxResults);
                this.cacheModel.putObject(cacheKey, list);
            }
        }
        return list;
    }

    public List executeQueryForList(RequestScope request, Connection conn, Object parameterObject, RowHandler rowHandler) throws SQLException {
        List list = this.statement.executeQueryForList(request, conn, parameterObject, rowHandler);
        return list;
    }

    public CacheKey getCacheKey(RequestScope request, Object parameterObject) {
        CacheKey key = this.statement.getCacheKey(request, parameterObject);
        if (!this.cacheModel.isReadOnly()) {
            key.update(request.getSession());
        }
        return key;
    }

    public void setBaseCacheKey(int base) {
        this.statement.setBaseCacheKey(base);
    }

    public void addExecuteListener(ExecuteListener listener) {
        this.statement.addExecuteListener(listener);
    }

    public void notifyListeners() {
        this.statement.notifyListeners();
    }

    public void initRequest(RequestScope request) {
        this.statement.initRequest(request);
    }

    public Sql getSql() {
        return this.statement.getSql();
    }

    public Class getParameterClass() {
        return this.statement.getParameterClass();
    }
}

